<?php

namespace App\Models\Marriage;

use App\Models\User;
use App\Models\Status;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Marriage\MarriageRegistrationDetail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Marriage\MarriageRegistrationGroomDetail;
use App\Models\Marriage\MarriageRegistrationBrideInformation;
use App\Models\Marriage\MarriageRegistrationPriestInformation;
use App\Models\Marriage\MarriageRegistrationWitnessInformation;

class MarriageRegistrationForm extends Model
{
    use HasFactory;

    protected $table = "marriage_new_reg_details";

    protected $fillable = [
        "user_id",
        "mp_id",
        "service_id",
        "ip",
        "application_no",
        "service_name",
        "registration_from_applicant_mobile_no",
        "registration_from_applicant_full_name",
        "registration_from_applicant_home_address",
        "registration_from_pincode",
        "registration_from_applicant_email",
        "registration_from_aadhar_card_no",
        "registration_from_alternate_mobile_number",
        "registration_from_pan_card_no",
        "registration_from_residential_ward_name",
        "registration_from_marriage_solemnized_within_maharashtra_state",
        "registration_details_form_filled_date",
        "registration_details_marriage_date_in_english",
        "registration_details_marriage_date_in_marathi",
        "registration_details_marriage_place_in_english",
        "registration_details_marriage_place_in_marathi",
        "registration_details_couple_photo",
        'registration_details_is_widow',
        'registration_details_is_previously_divorced',
        'registration_details_is_marriage_intercaste',
        'registration_details_wedding_card_image',
        'groom_info_fname_in_english',
        'groom_info_mname_in_english',
        'groom_info_lname_in_english',
        'groom_info_fname_in_marathi',
        'groom_info_mname_in_marathi',
        'groom_info_lname_in_marathi',
        'groom_info_address_in_english',
        'groom_info_address_in_marathi',
        'groom_info_pincode',
        'groom_info_pincode_in_marathi',
        'groom_info_mobile_no',
        'groom_info_email',
        'groom_info_aadhar_card_no',
        'groom_info_dob',
        'groom_info_age',
        'groom_info_gender',
        'groom_info_religion_by_birth',
        'groom_info_religion_by_adoption',
        'groom_info_photo',
        'groom_info_id_proof',
        'groom_info_residential_proof',
        'groom_info_age_proof',
        'groom_info_id_proof_file',
        'groom_info_residential_proof_file',
        'groom_info_age_proof_file',
        'groom_info_upload_signature',
        'groom_info_previous_status',
        'groom_info_previous_status_proof',
        'groom_info_upload_previous_status_proof',
        'bride_info_fname_in_english',
        'bride_info_mname_in_english',
        'bride_info_lname_in_english',
        'bride_info_fname_in_marathi',
        'bride_info_mname_in_marathi',
        'bride_info_lname_in_marathi',
        'bride_info_address_in_english',
        'bride_info_address_in_marathi',
        'bride_info_pincode',
        'bride_info_pincode_in_marathi',
        'bride_info_mobile_no',
        'bride_info_email',
        'bride_info_aadhar_card_no',
        'bride_info_dob',
        'bride_info_age',
        'bride_info_gender',
        'bride_info_religion_by_birth',
        'bride_info_religion_by_adoption',
        'bride_info_photo',
        'bride_info_id_proof',
        'bride_info_residential_proof',
        'bride_info_age_proof',
        'bride_info_id_proof_file',
        'bride_info_residential_proof_file',
        'bride_info_age_proof_file',
        'bride_info_upload_signature',
        'bride_info_previous_status',
        'bride_info_previous_status_proof',
        'bride_info_upload_previous_status_proof',
        'priest_info_fname_in_english',
        'priest_info_mname_in_english',
        'priest_info_lname_in_english',
        'priest_info_fname_in_marathi',
        'priest_info_mname_in_marathi',
        'priest_info_lname_in_marathi',
        'priest_info_address_in_english',
        'priest_info_address_in_marathi',
        'priest_info_mobile_no',
        'priest_info_age',
        'priest_info_religion',
        'priest_info_upload_signature',
        'first_witness_info_fname_in_english',
        'first_witness_info_fname_in_marathi',
        'first_witness_info_mobile_no',
        'first_witness_info_dob',
        'first_witness_info_age',
        'first_witness_info_gender',
        'first_witness_info_relation',
        'first_witness_info_address_in_english',
        'first_witness_info_address_in_marathi',
        'first_witness_info_id_proof',
        'first_witness_info_witness_photo',
        'first_witness_info_upload_signature',
        'first_witness_info_upload_document',
        'second_witness_info_fname_in_english',
        'second_witness_info_fname_in_marathi',
        'second_witness_info_mobile_no',
        'second_witness_info_dob',
        'second_witness_info_age',
        'second_witness_info_gender',
        'second_witness_info_relation',
        'second_witness_info_address_in_english',
        'second_witness_info_address_in_marathi',
        'second_witness_info_id_proof',
        'second_witness_info_witness_photo',
        'second_witness_info_upload_signature',
        'second_witness_info_upload_document',
        'third_witness_info_fname_in_english',
        'third_witness_info_fname_in_marathi',
        'third_witness_info_mobile_no',
        'third_witness_info_dob',
        'third_witness_info_age',
        'third_witness_info_gender',
        'third_witness_info_relation',
        'third_witness_info_address_in_english',
        'third_witness_info_address_in_marathi',
        'third_witness_info_id_proof',
        'third_witness_info_witness_photo',
        'third_witness_info_upload_signature',
        'third_witness_info_upload_document',
        'status',
        'is_payment_paid',
        'payment_date',
        'volume_number_mr',
        'sr_number_mr',
        'volumenumber_eng',
        'serialnumber_eng',
        'prescribed_doc',
        'remark'

    ];

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

      public function user()
    {
        return $this->belongsTo(User::class);
    }

    // public function marriageRegistrationDetail()
    // {
    //     return $this->hasOne(MarriageRegistrationDetail::class, 'marriage_reg_form_id', 'id');
    // }

    // public function marriageRegistrationGroomDetail()
    // {
    //     return $this->hasOne(MarriageRegistrationGroomDetail::class, 'marriage_reg_form_id', 'id');
    // }

    // public function marriageRegistrationBrideInformation()
    // {
    //     return $this->hasOne(MarriageRegistrationBrideInformation::class, 'marriage_reg_form_id', 'id');
    // }

    // public function marriageRegistrationPriestInformation()
    // {
    //     return $this->hasOne(MarriageRegistrationPriestInformation::class, 'marriage_reg_form_id', 'id');
    // }

    // public function marriageRegistrationWitnessInformation()
    // {
    //     return $this->hasOne(MarriageRegistrationWitnessInformation::class, 'marriage_reg_form_id', 'id');
    // }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
