<?php

namespace App\Models\MedicalHealth;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Status;
use Illuminate\Support\Facades\Request;


class CivilLocalSelfGovernmentNomination extends Model
{
    use HasFactory;

    protected $fillable = [
      'user_id',
      'ip',
      'zone',
      'first_name',
      'middle_name',
      'last_name',
      'marathi_first_name',
      'marathi_middle_name',
      'marathi_last_name',
      'mobile_num',
      'adhar_num',
      'email',
      'address',
      'marathi_address',
      'purpose',
      'marathi_purpose',
      'application_no',
      'service_id',
      'payment_date',
      'is_payment_paid',
      'is_paymnet_paid_appale_sarkar',
      'appale_sarkar_payment_date',
      'status',
      'prescribed_format'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }
    public function status(){
        return $this->hasOne(Status::class,'table_id','id');
    }

     public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    public static function boot(){
        parent::boot();

        static::creating(function($model){
            $model->ip = Request::ip();
        });
    }
}
