<?php

namespace App\Models\MedicalHealth;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class GutterCover extends Model
{
    use HasFactory;
    protected $table ="guttercover";
    protected $fillable = [
        'application_name',
        'area',
        'location',
        'landmark',
        'mobile_no',
        'email',
        'adhaarno',
        'ward_area',
        'details',
        'pincode',
        'gpsphoto',
        'user_id',
        'service_id',
        'ip',
        'aapale_sarkar_payment_date',
        'status',
        'application_no',
        'prescribed_docs',
        'completion_photos'

    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
