<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PaymentStatus extends Model
{
    protected $fillable = [
        'service_id',
        'table_id',
        'amount',
        'status', // 0=pending, 1=paid, 2=failed
        'transaction_id',
        'payment_date',
        'payment_mode'
    ];

    protected $dates = [
        'payment_date'
    ];

    /**
     * Get the service that owns the payment status
     */
    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }
}