<?php

namespace App\Models\Trade;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class PropertyDivisionIntoSubDivision extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'application_no',
        'speech_no',
        'date',
        'subject',
        'property_name',
        'property_address',
        'property_infom',
        'doc_upload',
        'upload_prescribed_formats',
        'upload_no_due_doc',
        'owner_doc',
        'ip',
        'ward_area',
        'email',
        'mobile_no',
        'property_num',
        'property_area',
        'flat_no',
        'ward',
        'zone',
        'adhaarno',
        'address',
        'applicantname',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
