<?php

namespace App\Models\PropertyTax;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class Newtaxation extends Model
{
    use HasFactory;

    protected $table = "newtaxations";

    protected $fillable = [
        'upic_id',
        'application_no',
        'user_id',
        'is_aapale_sarkar_payment_paid',
        'applicant_full_name',
        'applicant_full_address',
        'owner_name',
        'applicant_mobile_no',
        'email_id',
        'aadhar_no',
        'property_address',
        'property_no',
        'survey_number',
        'zone',
        'ward_area',
        'property_usage',
        'construction_type',
        'is_construction_authorized',
        'is_there_water_connection',
        'property_area',
        'uploaded_application',
        'certificate_of_no_dues',
        'service_id',
        'aapale_sarkar_payment_date',
        'status',
        'ip'
    ];

       public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected function serviceId(): Attribute
    {
        return Attribute::make(
            set: fn(string $value) => 5,
        );
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
