<?php

namespace App\Models\PropertyTax;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class NoDueCertificate extends Model
{
    use HasFactory;

    protected $table = "no_due_certificates";

    protected $fillable = [
        'upic_id',
        'application_no',
        'user_id',
        'is_aapale_sarkar_payment_paid',
        'applicant_name_eng',
        'applicant_name_mar',
        'applicant_full_address_eng',
        'applicant_full_address_mar',
        'applicant_mobile_no',
        'email_id',
        'aadhar_no',
        'zone',
        'ward_area',
        'property_address',
        'house_no',
        'index_number',
        'property_no',
        'annual_period',
        'uploaded_application',
        'service_id',
        'aapale_sarkar_payment_date',
        'status',
        'ip',
        'connection_no',
        'owner_name',
        'owner_full_add',
        'land_mark',
        'receipt_doc',
        'prescribed_doc',
        'uploaded_applications',
        'ward'
    ];

     public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected function serviceId(): Attribute
    {
        return Attribute::make(
            set: fn(string $value) => 2,
        );
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
