<?php

namespace App\Models\Pwd;

use App\Models\Pwd\GrantingTelecom;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GrantingTelecomDetails extends Model
{
    use HasFactory;

    protected $table= "gratingtelecomdetails";
    protected $fillable = [
        'gratingtelecom_id',
        'roadtype',
        'defect_factor',
        'startpoint',
        'endpoint',
        'length',
    ];

    public function grating()
    {
        return $this->hasMany(GrantingTelecom::class, 'id', 'construction_road_cutting_id');
    }

}
