<?php

namespace App\Models\PwdElectrical;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class CompletionCertificateDevelopment extends Model
{
    use HasFactory;

    protected $fillable = ['user_id','ip','applicant_name','applicant_address','mobile_no','email_id','company_name','work_name','work_order_no','work_comp_certi','work_order_doc','work_completition_certificate','application_no',
        'service_id',
        'status',
        'prescribed_docs',
        'ward',
        'upload_report',
        'upload_photo',
        'geotags',
        'ward_area'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
