<?php

namespace App\Models\PwdElectrical;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class SarvajanikJagetunJanaraRastyachaDakhla extends Model
{
    use HasFactory;
    protected $fillable = [
        'id',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'email_id',
        'road_name',
        'property_address',
        'survery_plan_doc',
        'side_visit_doc',
        'property_doc',
        'application_no',
        'service_id',
        'status',
        'ip',
        'user_id',
        'prescribed_docs',
        'ward_area',
        'geotags'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
