<?php

namespace App\Models\PwdElectrical;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class StromWaterDrain extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'ip',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'email_id',
        'property_owner_name',
        'property_address',
        'ward_area',
        'property_type',
        'authorization',
        'plan_copy',
        'side_visit_geotag_pic',
        'property_doc',
        'application_no',
        'service_id',
        'prescribed_docs',
        'survey_details'
    ];

       public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
