<?php

namespace App\Models\PwdElectrical;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class VikasKamachGopniyDakhla extends Model
{
    use HasFactory;
    protected $fillable = [
        'id',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'email_id',
        'company_name',
        'work_name',
        'work_order_no',
        'work_completion_date',
        'work_order_doc',
        'work_completion_doc',
        'nigarmit_doc',
        'company_registration_doc',
        'application_no',
        'service_id',
        'status',
        'ip',
        'user_id',
        'prescribed_docs'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
