<?php

namespace App\Models\PwdElectrical;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class WindBlow extends Model
{
    use HasFactory;

    protected $table = "windblow";

    protected $fillable = [
        'application_no',
        'service_id',
        'user_id',
        'applicant_name',
        'applicant_address',
        'mobile_no',
        'email_id',
        'owner_name',
        'owner_address',
        'prabhag_samiti',
        'cc_oc_certificates',
        'fire_nocs',
        'solid_waste_nocs',
        'structural_stability_certificates',
        'electrical_safety_certificates',
        'water_supply_sewage_nocs',
        'prabhag_office_nocs',
        'school_gps_photos',
        'is_payment_paid',
        'payment_date',
        'status',
        'ip',
        'solid_waste_nocs',
        'upload_prescribeds'
    ];

       public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
