<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RegistrationSequence extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_id',
        'year',
        'sequence',
    ];

    /**
     * Increment and get the next sequence number for a given service and year
     */
    public static function nextSequence($serviceId, $year)
    {
        $record = self::firstOrCreate(
            ['service_id' => $serviceId, 'year' => $year],
            ['sequence' => 0]
        );

        $record->increment('sequence');
        return $record->sequence;
    }
}
