<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = ['service_id', 'name', 'image', 'is_parent', 'route_name', 'table_name', 'background_color'];

    public function services()
    {
        return $this->hasMany(Service::class, 'service_id', 'id');
    }
    public function mainService()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }
}
