<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceName extends Model
{
    use HasFactory;

    protected $fillable = ['service_id', 'service_name', 'model', 'add_route', 'edit_route', 'certificate_route', 'receipt_route', 'demandnote', 'payment', 'reject_certificate'];

    public function fees()
    {
        return $this->hasMany(Fees::class, 'service_name_id', 'service_id');
    }

    public function signature()
    {
        return $this->hasMany(Signature::class, 'service_id', 'service_name');
    }

    public function hierarchy()
    {
        return $this->belongsTo(ApprovalRequestHierarchy::class, 'service_id', 'service_id');
    }

    public function department()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id')->where('is_parent', 0);
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }
}