<?php

namespace App\Models\Trade;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class TradeNocForMandap extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'applicant_name',
        'event_name',
        'commissioner_name',
        'registration_no',
        'registration_year',
        'name_of_chairman',
        'president_mobile_no',
        'ownership_of_place',
        'stage_permission_date',
        'stage_permission_end_date',
        'no_of_days',
        'stage_address',
        'zone',
        'ward_area',
        'plot_no',
        'stage_height',
        'stage_length',
        'stage_Width',
        'stage_area',
        'no_of_volunteer_workers',
        'stage_contractor_address',
        'contractor_contact_no',
        'decorator_or_electrical_contractor_name',
        'decorator_or_contractor_address',
        'decorator_or_electrical_contractor_contact_no',
        'sound_or_speaker_contractor_name',
        'sound_or_speaker_address',
        'sound_or_speaker_contractor_contact_no',
        'sound_or_speaker_type',
        'concerned_police_station',
        'concerned_traffic_police_station',
        'nearest_fire_station',
        'board_registration_document',
        'no_objection_document',
        'location_map_document',
        'fire_last_year_noObjection_document',
        'traffic_last_year_noObjection_document',
        'annexure',
        'ip',
        'application_no',
        'registration_date',
        'last_year_permission',
        'ganesh_murti_type',
        'murti_height',
        'mandap_documents',
        'local_polic_documents',
        'applicant_mobile',
        'applicant_email',
        'applicant_address',
        'prescribed_doc', 
        'agnishamak_javak_kramank',
        'agnishamak_police_date',
        'stanikpolice_javak_kramank',
        'stanikpolice_date',
        'sambandhit_javak_kramank',
        'sambandhit_date'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
