<?php

namespace App\Models;

use App\Models\Role;
use App\Models\Department;
use App\Models\DepartmentUser;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles; // Make sure to use this trait

class User extends Authenticatable
{
    use HasApiTokens, Notifiable, HasRoles, HasFactory; // You are using HasRoles here

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'mobile',
        'password',
        //'age',
        //'aadhar_no',
        //'gender',
        'user_id',
        'trackid',
        'is_aapale_sarkar_user',
        'address',
        'otp'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Many-to-many relationship with departments.
     */
    public function departments()
    {
        return $this->hasMany(DepartmentUser::class, 'user_id','id');
    }

   public function roles()
    {
        return $this->belongsToMany(Role::class, 'model_has_roles', 'model_id', 'role_id');
    }

     public function departmentUsers()
    {
        return $this->hasMany(DepartmentUser::class, 'user_id','id');
    }

    public function departmentUser()
    {
        return $this->hasOne(DepartmentUser::class, 'user_id','id');
    }




    /**
     * Many-to-many relationship with roles.
     * Spatie automatically uses the 'role_user' pivot table unless configured otherwise.
     */


    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
}
