<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class Illegalwaterconnection extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'complainants_full_name',
        'address',
        'aadhar_no',
        'mobile_no',
        'email_id',
        'unauthorized_tap_connection',
        'zone',
        'ward_area',
        'plot_no',
        'house_no',
        'landmark',
        'unauthorized_connection_address',
        'current_connection_is_authorized',
        'applicant_or_tenant',
        'unauthorized_is_tenant',
        'criminal_judicial_issue',
        'existing_connection_detail',
        'place_belongs_to_municipal',
        'comment',
        'application_document',
        'ip',
        'application_no',
        'address_property',
        'home_no',
        'address_property',
        'applicant_name',
        'connection_no',
        'total_connection',
        'info_unauth_con',
        'existing_tap_con_details',
        'existing_top_con_unautorized',

        'Connection_Type',
        'House_Number',
        'Property_Owner_Name',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'zone',
        'Ward',
        'OutstandingAmt',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
