<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\user;

class WaterChangeInUse extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'property_owner_name',
        'aadhar_no',
        'mobile_no',
        'email_id',
        'zone',
        'ward_area',
        'plot_no',
        'house_no',
        'landmark',
        'address',
        'property_type',
        'water_connection_no',
        'applicant_is_on_rent',
        'Water_Connection_Size',
        'connection_no',
        'water_usage',
        'new_water_con_usage',
        'usage_residence_type',
        'current_connection_is_illegal',
        'no_of_user',
        'place_belongs_to_municipal',
        'any_police_complaint',
        'application_document',
        'nodues_document',
        'ip',
        'application_no',
        'property_no',
        'applicant_address',
        'applicant_name',
        'total_connection',
        'sub_usage',
        'new_sub_usage',
        'no_of_existing_con',
        'Water_Connection_Size_Count',

        'Connection_Type',
        'House_Number',
        'Full_Address_Of_The_Property',
        'Water_Connection_Usage',
        'Water_Connection_Number',
        'Ward',
        'OutstandingAmt',
        'Water_Connection_Label_one',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
