<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class WaterChangeOwnership extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'new_owner_name',
        'address',
        'aadhar_no',
        'mobile_no',
        'email_id',
        'property_no',
        'zone',
        'ward_area',
        'new_tap_connection',
        'house_no',
        'landmark',
        'current_connection_is_authorized',
        'no_of_user',
        'applicant_or_tenant',
        'old_owner_name',
        'criminal_judicial_issue',
        'tap_size',
        'existing_connection_detail',
        'place_belongs_to_municipal',
        'comment',
        'application_document',
        'ownership_document',
        'nodues_document',
        'ip',
        'application_no',
        'total_connection',
        'connection_no',
        'owner_name',
        'owner_add',
        'sub_usage',
        'applicant_name',
        'existing_water_bill',
        'tax_bill_or_transfer_order',
        'stamp_paper_or_noobjection_cert',
        'aadhar_doc',
        'electricity_bill_or_pan_card',
        'Water_Connection_Size_Count',
        'New_Property_Owner_Name',


        'Connection_Type',
        'House_Number',
        'Property_Owner_Name',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'zone',
        'Ward',
        'OutstandingAmt',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
