<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\user;

class WaterPressureComplaint extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'property_owner_name',
        'aadhar_no',
        'mobile_no',
        'email_id',
        'zone',
        'ward_area',
        'plot_no',
        'house_no',
        'landmark',
        'address',
        'current_connection_is_illegal',
        'applicant_is_on_rent',
        'criminal_judicial_issue',
        'tap_size',
        'current_existing_tap_type',
        'place_belongs_to_municipal',
        'comment',
        'prev_water_bill',
        
        'mestri_site',
        'application_document',
        'ip',
        'application_no',
        'applicant_name',
        'total_connection',
        'connection_no',

        'Connection_Type',
        'House_Number',
        'Property_Owner_Name',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'zone',
        'Ward',
        'OutstandingAmt',
        'panycha_type_add',
        'jramountone',
        'running_meterone',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
