<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;

class WaterTaxBill extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'applicant_name',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'property_owner_name',
        'connection_no',
        'aadhar_no',
        'email_id',
        'mobile_no',
        'zone',
        'ward_area',
        'address',
        'city_serve_no',
        'property_no',
        'house_no',
        'plot_no',
        'landmark',
        'new_water_con',
        'current_connection_is_illegal',
        'applicant_or_tenant',
        'criminal_judicial_issue',
        'place_belongs_to_municipal',
        'comment',
        'application_document',
        'ip',
        'application_no',
        'billing_cycle',
        'connection_size',
        'water_sub_usage',
        'water_connection',
        'owner_full_add',
        'test_report',
        'no_of_existing_con',

        'Connection_Type',
        'House_Number',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'zone',
        'Ward',
        'OutstandingAmt',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
