<?php

namespace App\Models\WaterDepartment;

use App\Models\Status;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WaterUnavailabilitySupply extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'applicant_name',
        'email_id',
        'mobile_no',
        'address',
        'aadhar_no',
        'police_station',
        'name_of_commercail_establishment',
        'zone',
        'ward_area',
        'prev_water_bill',
        'address_of_com_establishment',
        'no_of_working_person',
        'per_day_water_demand',
        'other_info',
        'ip',
        'Water_Connection_Number',
        'Connection_Type',
        'House_Number',
        'Property_Owner_Name',
        'Full_Address_Of_The_Property',
        'Water_Connection_Size',
        'Water_Connection_Usage',
        'OutstandingAmt',
        'Ward',
        'connection_no',
        'application_document',
        'no_of_tap_con',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
