<?php

namespace App\Models\WaterDepartment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use App\Models\Status;
use App\Models\User;


class Waternewconnection extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'water_connection_no',
        'aapale_sarkar_payment_date',
        'is_aapale_sarkar_payment_paid',
        'status',
        'applicant_full_name',
        'aadhar_no',
        'mobile_no',
        'email_id',
        'zone',
        'prabhag',
        'ward',
        'ward_area',
        'city_servey_no',
        'address',
        'landmark',
        'no-of-flats-shops',
        'property_no',
        'total_person',
        'distance',
        'water_connection_use',
        'water_connection_sub_use',
        'road_repair_type',
        'road_repair_length',
        'pipe_size',
        'no_of_tap',
        'current_no_of_tap',
        'no_of_flats_shops',
        'total_tenants',
        'written_application_document',
        'ownership_document',
        'no_dues_document',
        'ip',
        'application_no',
        'jote_doc',
        'stamp_karnama',
        'oc_and_cc',
        'structure_photo',
        'address_proof',
        'jramount',
        'running_meter'

    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function status()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    public function statuses()
    {
        return $this->hasOne(Status::class, 'table_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = Request::ip();
        });
    }
}
