<?php

namespace App\Providers;

use App\Models\Status;
use App\Models\ApprovalHierarchies;
use Illuminate\Support\ServiceProvider;
use App\Observers\StatusObserver;
use App\Observers\ApprovalHierarchiesObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
       Status::observe(StatusObserver::class);
       ApprovalHierarchies::observe(ApprovalHierarchiesObserver::class);
    }
}
