<?php

namespace App\Services\CityStructure;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\CityStructure\CityStructurePartMap;
use App\Models\ServiceCredential;
use App\Services\CurlAPiService;
use App\Services\AapaleSarkarLoginCheckService;
use App\Models\Status;
use App\Services\CommonService;

class PartZoneService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "186";
            if ($request->hasFile('prescribed_formats')) {
                $request['prescribed_format'] = $request->prescribed_formats->store('city-structure/part-map','public');
            }
            if ($request->hasFile('upload_city_survey_certificates')) {
                $request['upload_city_survey_certificate'] = $request->upload_city_survey_certificates->store('city-structure/part-map','public');
            }
            if ($request->hasFile('upload_city_servey_maps')) {
                $request['upload_city_servey_map'] = $request->upload_city_servey_maps->store('city-structure/part-map','public');
            }
            $cityStructurePartMap = CityStructurePartMap::create($request->except('application_no'));
            if($cityStructurePartMap){
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $cityStructurePartMap->id . '/' . date('dmY');
                $cityStructurePartMap->application_no = $applicationNo;
                $cityStructurePartMap->save();
               $status = Status::create([
                    'service_id' => 186,
                    'department_id' =>2,
                    'table_id' => $cityStructurePartMap->id,
                    'user_id' => Auth::user()->id
                ]);
            $this->commonservice->store_approval_hierarchies($cityStructurePartMap, Auth::user(), $status);

            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in store method: ' . $e->getMessage());
            return false;
        }
    }


    public function edit($id)
    {
        return CityStructurePartMap::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            // Find the existing record
            $cityStructurePartMap = CityStructurePartMap::findOrFail($id);
            // Handle file uploads and update original file names
            if ($request->hasFile('prescribed_formats')) {
                if ($cityStructurePartMap && Storage::exists($cityStructurePartMap->prescribed_format)) {
                    Storage::delete($cityStructurePartMap->prescribed_format);
                }
                $request['prescribed_format'] = $request->prescribed_formats->store('city-structure/part-map');
            }
            if ($request->hasFile('upload_city_survey_certificates')) {
                if ($cityStructurePartMap && Storage::exists($cityStructurePartMap->upload_city_survey_certificate)) {
                    Storage::delete($cityStructurePartMap->upload_city_survey_certificate);
                }
                $request['upload_city_survey_certificate'] = $request->upload_city_survey_certificates->store('city-structure/part-map');
            }
            if ($request->hasFile('upload_city_servey_maps')) {
                if ($cityStructurePartMap && Storage::exists($cityStructurePartMap->upload_city_servey_map)) {
                    Storage::delete($cityStructurePartMap->upload_city_servey_map);
                }
                $request['upload_city_servey_map'] = $request->upload_city_servey_maps->store('city-structure/part-map');
            }
            $cityStructurePartMap->update($request->all());



            // code to send data to department
            // if ($request->hasFile('prescribed_formats')) {
            //     $request['prescribed_format'] = $this->curlAPiService->convertFileInBase64($request->file('prescribed_formats'));
            // } else {
            //     $request['prescribed_format'] = "";
            // }
            // if ($request->hasFile('upload_city_survey_certificates')) {
            //     $request['upload_city_survey_certificate'] = $this->curlAPiService->convertFileInBase64($request->file('upload_city_survey_certificates'));
            // } else {
            //     $request['upload_city_survey_certificate'] = "";
            // }
            // if ($request->hasFile('upload_city_servey_maps')) {
            //     $request['upload_city_servey_map'] = $this->curlAPiService->convertFileInBase64($request->file('upload_city_servey_maps'));
            // } else {
            //     $request['upload_city_servey_map'] = "";
            // }
            // $request['application_no'] = $cityStructurePartMap->application_no;
            // $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? Auth::user()->user_id : Auth::user()->id;
            // $newData = $request->except(['_token', 'id', 'prescribed_formats', 'upload_city_survey_certificates', 'upload_city_servey_maps']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.water') . 'AapaleSarkarAPI/NewTaxation.asmx/RequestForUpdateNewTaxation', 'NewTaxation');

            // // Decode JSON string to PHP array
            // $data = json_decode($data, true);

            // if ($data['d']['Status'] == "200") {
            // Access the application_no
            DB::commit();
            return true;
            // } else {
            //     DB::rollback();
            //     return false;
            // }
            // end of code to send data to department
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return false;
        }
    }
}
