<?php

namespace App\Services\CityStructure;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\CityStructure\CityStructureZoneCertificate;
use App\Models\ServiceCredential;
use App\Services\CurlAPiService;
use App\Services\AapaleSarkarLoginCheckService;
use App\Models\Status;
use App\Services\CommonService;

class ZoneCertificateService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice  = $commonservice;
    }

   public function store($request)
    {
        DB::beginTransaction();

        try {
            // Merge extra values into request
            $request->merge([
                'user_id' => Auth::id(),
                'service_id' => 185,
            ]);

            // Handle file uploads
            if ($request->hasFile('prescribed_formats')) {
                $path = $request->file('prescribed_formats')->store('city-structure/zone-certificate', 'public');
                $request->merge(['prescribed_format' => $path]);
            }

            if ($request->hasFile('upload_city_survey_certificates')) {
                $path = $request->file('upload_city_survey_certificates')->store('city-structure/zone-certificate', 'public');
                $request->merge(['upload_city_survey_certificate' => $path]);
            }

            if ($request->hasFile('upload_city_servey_maps')) {
                $path = $request->file('upload_city_servey_maps')->store('city-structure/zone-certificate', 'public');
                $request->merge(['upload_city_servey_map' => $path]);
            }

            if ($request->hasFile('adhaar_card')) {
                $path = $request->file('adhaar_card')->store('city-structure/zone-certificate', 'public');
                $request->merge(['adhaar_cards' => $path]);
            }


            $cityStructureZoneCertificate = CityStructureZoneCertificate::create($request->except('application_no'));


            if ($cityStructureZoneCertificate) {
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $cityStructureZoneCertificate->id . '/' . date('dmY');
                $cityStructureZoneCertificate->application_no = $applicationNo;
                $cityStructureZoneCertificate->save();

                // Save status
                $status = Status::create([
                    'service_id' => 185,
                    'department_id' => 2,
                    'table_id' => $cityStructureZoneCertificate->id,
                    'user_id' => Auth::id()
                ]);


                $this->commonservice->store_approval_hierarchies($cityStructureZoneCertificate, Auth::user(), $status);
            }

            DB::commit();
            return true;

        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Store error: ' . $e->getMessage(), [
                'file' => $e->getFile(),
                'line' => $e->getLine(),
            ]);
            return false;
        }
    }



    public function edit($id)
    {
        return CityStructureZoneCertificate::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            // Find the existing record
            $cityStructureZoneCertificate = CityStructureZoneCertificate::findOrFail($id);
            // Handle file uploads and update original file names
            if ($request->hasFile('prescribed_formats')) {
                if ($cityStructureZoneCertificate && Storage::exists($cityStructureZoneCertificate->prescribed_format)) {
                    Storage::delete($cityStructureZoneCertificate->prescribed_format);
                }
                $request['prescribed_format'] = $request->prescribed_formats->store('city-structure/zone-certificate','public');
            }
            if ($request->hasFile('upload_city_survey_certificates')) {
                if ($cityStructureZoneCertificate && Storage::exists($cityStructureZoneCertificate->upload_city_survey_certificate)) {
                    Storage::delete($cityStructureZoneCertificate->upload_city_survey_certificate);
                }
                $request['upload_city_survey_certificate'] = $request->upload_city_survey_certificates->store('city-structure/zone-certificate','public');
            }
            if ($request->hasFile('upload_city_servey_maps')) {
                if ($cityStructureZoneCertificate && Storage::exists($cityStructureZoneCertificate->upload_city_servey_map)) {
                    Storage::delete($cityStructureZoneCertificate->upload_city_servey_map);
                }
                $request['upload_city_servey_map'] = $request->upload_city_servey_maps->store('city-structure/zone-certificate','public');
            }
            $cityStructureZoneCertificate->update($request->all());



            // code to send data to department
            // if ($request->hasFile('prescribed_formats')) {
            //     $request['prescribed_format'] = $this->curlAPiService->convertFileInBase64($request->file('prescribed_formats'));
            // } else {
            //     $request['prescribed_format'] = "";
            // }
            // if ($request->hasFile('upload_city_survey_certificates')) {
            //     $request['upload_city_survey_certificate'] = $this->curlAPiService->convertFileInBase64($request->file('upload_city_survey_certificates'));
            // } else {
            //     $request['upload_city_survey_certificate'] = "";
            // }
            // if ($request->hasFile('upload_city_servey_maps')) {
            //     $request['upload_city_servey_map'] = $this->curlAPiService->convertFileInBase64($request->file('upload_city_servey_maps'));
            // } else {
            //     $request['upload_city_servey_map'] = "";
            // }
            // $request['application_no'] = $cityStructureZoneCertificate->application_no;
            // $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? Auth::user()->user_id : Auth::user()->id;
            // $newData = $request->except(['_token', 'id', 'prescribed_formats', 'upload_city_survey_certificates', 'upload_city_servey_maps']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.water') . 'AapaleSarkarAPI/NewTaxation.asmx/RequestForUpdateNewTaxation', 'NewTaxation');

            // // Decode JSON string to PHP array
            // $data = json_decode($data, true);

            // if ($data['d']['Status'] == "200") {
            // Access the application_no
            DB::commit();
            return true;
            // } else {
            //     DB::rollback();
            //     return false;
            // }
            // end of code to send data to department
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return false;
        }
    }
}
