<?php

namespace App\Services;

use App\Models\DemolishingProperty;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\NewTaxAssessment;
use App\Models\ServiceCredential;
use App\Models\Status;


class DemolishingPropertyService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {
        DB::beginTransaction();
        $user = Auth::user();
        $data = $request->all();
        $data['user_id'] = Auth::user()->id;
        $data['service_id'] = "2022";

        $ward = DB::table('prabhag_wards')
            ->where('ward_name', $data['ward_area'])
            ->first();

        if ($ward) {
            $data['ward_area'] = $ward->id;
        } else {
            throw new \Exception("Ward not found for name: " . $data['ward_area']);
        }

        $fileFields = [
            'application_file',
            'no_dues_certificate'
        ];

        foreach ($fileFields as $field) {
            if ($request->hasFile($field)) {
                $file = $request->file($field);
                $filename = time() . '_' . $file->getClientOriginalName();
                $path = $file->storeAs('property-tax/new-taxation', $filename, 'public');
                $data[$field] = $path;
            }
        }

        $demolishingproperty = DemolishingProperty::create($data);

        if ($demolishingproperty) {
            $applicationNo = 'MBMC/' . $data['service_id'] . '/' . $demolishingproperty->id . '/' . date('dmY');
            $demolishingproperty->update(['application_no' => $applicationNo]);
            $status = Status::create([
                'service_id' => 2022,
                'department_id' => 4,
                'table_id' => $demolishingproperty->id,
                'user_id' => Auth::user()->id
            ]);

            $this->commonservice->store_approval_hierarchies($demolishingproperty, $user, $status);

            $payload = [
                "RTSPostData" => [
                    [
                        "User_Id" => $user->id,
                        "Service_Code" => "2022",
                        "Service" => "Tax Assessment On Demolishing And Reconstruction Of The property",
                        "Pay_ReferenceNo" => "1",
                        "Pay_Amount" => "1",
                        "Pay_Date" => "22-Jul-2025",
                        "Department_Code" => "4",
                        "Department" => "Property Tax Department",
                        "Status" => 1,
                        "Applicant_English_Name" => $demolishingproperty->f_name,
                        "Applicant_Marathi_Name" => $demolishingproperty->f_name,
                        "Applicant_English_Address" => $user->address,
                        "Applicant_Marathi_Address" => $user->address,
                        "Mobile" => $demolishingproperty->mobile_num,
                        "Email" => $demolishingproperty->email,
                        "AadharNo" => $user->aadhar_no,
                        "PropertyNo" => $demolishingproperty->property_address,
                        "OwnerName" => $demolishingproperty->property_owner_name,
                        "Property_Address" => $demolishingproperty->property_address,
                        "Property_Area" => $demolishingproperty->property_area,
                        "FlatNo" => $demolishingproperty->m_name,
                        "WardId" => $demolishingproperty->ward,
                        "ZoneId" => $demolishingproperty->zone,
                        "Total_Outstanding" => $demolishingproperty->l_name,
                        "Annual_Period" => "2024-2025",
                        "Application_Form" => "mbmc",
                        "Mode" => 1,
                        "Application_No" => $applicationNo,
                        "Application_Status" => $demolishingproperty->application_status ?? "P"
                    ]
                ]
            ];

            $jsonPayload = json_encode($payload);
            $encryptedString = $this->commonservice->encryptStringProperty($jsonPayload);
            $this->commonservice->propertyDataStrore($encryptedString);
        }

        DB::commit();
        return [true];
    }


    public function edit($id)
    {
        return DemolishingProperty::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $demolishingproperty = DemolishingProperty::find($id);

            // Handle file uploads and update original file names

            $demolishingproperty->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
