<?php

namespace App\Services\DrinageWater;

use App\Models\DrinageWater\FailureWater;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;
use App\Services\CommonService;

class FailureWaterSupplyService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();

            $data['user_id'] = Auth::id();
            $data['service_id'] = 8990;

            $fileFields = [
                'application_doc'   => 'application_doc',
                'site_photo' => 'site_photo',
                'cc_oc' => 'cc_oc',
                'blue_print' => 'blue_print',
                'other_doc' => 'other_doc',
            ];

            foreach ($fileFields as $input => $column) {
                if ($request->hasFile($input)) {
                    $data[$column] = $request->file($input)->store('DrinageWater/failurewater', 'public');
                }
            }

            $filteredData = collect($data)->except('application_no')->toArray();

            $grantingTelecom = FailureWater::create($filteredData);

            if ($grantingTelecom) {
                $applicationNo = 'MBMC/' . $data['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();

            $status = Status::create([
                    'service_id' => 8990,
                    'department_id' => 12,
                    'table_id' => $grantingTelecom->id,
                    'user_id' => Auth::user()->id
                ]);
           $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in store method: ' . $e->getMessage());
            return [false, $e->getMessage()];
        }
    }

    public function edit($id)
    {
        return FailureWater::find($id);
    }

    // public function update_old($request, $id)
    // {
    //     // dd($request->all());
    //     DB::beginTransaction();
    //     try {
    //         // Find the existing record
    //         $stronwaterdrain = FailureWater::find($id);

    //         // Handle file uploads and update original file names

    //         $stronwaterdrain->update($request->all());

    //         DB::commit();
    //         return [true];
    //     } catch (\Exception $e) {
    //         DB::rollback();
    //         Log::info($e);
    //         return [false, $e->getMessage()];
    //     }
    // }



    public function update($request, $id)
{
    DB::beginTransaction();
    try {
        // Existing record find karo
        $stronwaterdrain = FailureWater::find($id);

        // Agar file upload hui hai
        if ($request->hasFile('upload_photos')) {
            // File ko store karo aur path ko request data me daalo
            $requestData = $request->all();
            $requestData['upload_photos'] = $request->file('upload_photos')
                ->store('failurewater/failure-water-supply', 'public');
        } else {
            $requestData = $request->all();
        }

        // Record update karo
        $stronwaterdrain->update($requestData);

        DB::commit();
        return [true];
    } catch (\Exception $e) {
        DB::rollback();
        Log::info($e);
        return [false, $e->getMessage()];
    }
}

}
