<?php

namespace App\Services\DrinageWater;

use App\Models\DrinageWater\SewerageNoc;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;
use App\Services\CommonService;

class SewerageNocService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {
           $data = $request->all();

            $data['user_id'] = Auth::id();
            $data['service_id'] = 8920;

            $fileFields = [
                'application_doc'   => 'application_doc',
                'bill_doc' => 'bill_doc',
                'site_photo' => 'site_photo',
                'blue_print' => 'blue_print',
                'other_document' => 'other_document',
            ];

            foreach ($fileFields as $input => $column) {
                if ($request->hasFile($input)) {
                    $data[$column] = $request->file($input)->store('SewerageNoc/NOC', 'public');
                }
            }

        $filteredData = collect($data)->except('application_no')->toArray();
        $grantingTelecom = SewerageNoc::create($filteredData);


        if($grantingTelecom){

                $applicationNo = 'MBMC/' . $data['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();

           $status = Status::create([
                    'service_id' =>8920,
                    'department_id' =>12,
                    'table_id' => $grantingTelecom->id,
                    'user_id'=>Auth::user()->id
                ]);
           $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

            }


        DB::commit();
        return [true];


    }

    public function edit($id)
    {
        return SewerageNoc::find($id);
    }

    public function update_old($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $stronwaterdrain = SewerageNoc::find($id);

            // Handle file uploads and update original file names

            $stronwaterdrain->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }



    public function update($request, $id)
{
    DB::beginTransaction();
    try {
        // Existing record find karo
        $sewerageNoc = SewerageNoc::find($id);

        // Agar file upload hui hai
        if ($request->hasFile('upload_photos')) {
            // File ko store karo aur request me merge karo
            $request->merge([
                'upload_photos' => $request->file('upload_photos')
                    ->store('sewarage-noc/sewarage-nocs', 'public')
            ]);
        }

        // Record update karo
        $sewerageNoc->update($request->all());

        DB::commit();
        return [true];
    } catch (\Exception $e) {
        DB::rollback();
        Log::info($e);
        return [false, $e->getMessage()];
    }
}

}
