<?php

namespace App\Services\ES;

use App\Models\EstateVibhag\ElectricMeterNameTransfer;
use App\Models\PwdElectrical\CompletionCertificateDevelopment;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;
use App\Services\CommonService;

class ElectricMeterTransferService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService  $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    // public function store($request)
    // {

    //     $request['user_id'] = Auth::user()->id;
    //     $request['service_id'] = "9042";
    //     $request['application_no'] = "MBMCSWD-" . time();




    //         if($electricmetertransfer){

    //             Status::create([
    //                 'service_id' =>9042,
    //                 'department_id' =>4,
    //                 'table_id' => $electricmetertransfer->id
    //             ]);
    //         }




        public function store(Request $request)
        {
        $user = Auth::user();
        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "9042";



        $documentFields = [
            'mul_parnaga_pic',
            'adhar_card_pic',
            'pic',
            'handicap_pic',
            'caste_pic',
            'milk_center_pic',
            'gumasta_license_pic',
            'prescribed_doc'
        ];

        foreach ($documentFields as $field) {
            $formField = $field . 's';

            if ($request->hasFile($formField)) {
                $originalFileName = $request->file($formField)->getClientOriginalName();
                $request[$field] = $request->file($formField)->storeAs("pwd_electrical/$formField/", $originalFileName, 'public');
            }
        }


         $grantingTelecom = ElectricMeterNameTransfer::create($request->except('application_no'));

        if ($grantingTelecom) {

             $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();

            $status =   Status::create([
                    'service_id' =>9042,
                    'department_id' =>11,
                    'table_id' => $grantingTelecom->id,
                    'user_id' => Auth::user()->id
                ]);
                 $this->commonservice->store_approval_hierarchies($grantingTelecom, $user, $status);

            }


        DB::commit();
        return [true];

    }

    public function edit($id)
    {
        return ElectricMeterNameTransfer::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $electricmetertransfer = ElectricMeterNameTransfer::find($id);

            // Handle file uploads and update original file names

            $electricmetertransfer->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
