<?php

namespace App\Services\ES;

use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\EstateVibhag\SolarPower;
use App\Models\Status;
use App\Services\CommonService;

class SolarPowerService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }

        public function store(Request $request)
        {
            $user =  Auth::user();
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "8930";


            $documentFields = [
                'mul_parnaga_pic',
                'adhar_card_pic',
                'pic',
                'handicap_pic',
                'caste_pic',
                'milk_center_pic',
                'gumasta_license_pic',
                'prescribed_doc'
            ];

            foreach ($documentFields as $field) {
                $formField = $field . 's';
                if ($request->hasFile($formField)) {
                    $originalFileName = $request->file($formField)->getClientOriginalName();
                    $request[$field] = $request->file($formField)->store("solarpower/$formField", 'public');
                }
            }


         $grantingTelecom = SolarPower::create($request->except('application_no'));

            if($grantingTelecom){

                 $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();

            $status =   Status::create([
                    'service_id' => 8930,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                    'user_id'=> Auth::user()->id
                ]);
            $this->commonservice->store_approval_hierarchies($grantingTelecom, $user, $status);
            }


        DB::commit();
        return [true];

    }

    public function edit($id)
    {
        return SolarPower::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $electricmetertransfer = SolarPower::find($id);
             $status_id =  $electricmetertransfer->statuses()
                ->where('service_id',  $electricmetertransfer->service_id)
                ->first()?->id;
            $electricmetertransfer->update($request->all());
             if ( $electricmetertransfer->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
