<?php

namespace App\Services\FireDepartment;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\FireDepartment\FireNoObjection;
use App\Models\ServiceCredential;
use App\Services\CurlAPiService;
use App\Services\AapaleSarkarLoginCheckService;
use App\Models\Status;
use App\Services\CommonService;

class NoObjectionService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $user = Auth::user();
            $request->merge([
                'user_id' => $user->id,
                'service_id' => 183
            ]);

            $fileFields = [
                'uploaded_applications' => 'uploaded_application',
                'no_dues_documents' => 'no_dues_document',
                'architect_application_documents' => 'architect_application_document',
                'fire_prevention_documents' => 'fire_prevention_document',
                'capitation_fee_documents' => 'capitation_fee_document',
                'upload_prescribed_formats' => 'upload_prescribed_format'
            ];

            foreach ($fileFields as $input => $column) {
                if ($request->hasFile($input)) {
                    $path = $request->file($input)->store('fire-department/no-objection');
                    $request->merge([$column => $path]);
                }
            }

            $fireNoObjection = FireNoObjection::create($request->except([
                'application_no',
                'uploaded_applications',
                'no_dues_documents',
                'architect_application_documents',
                'fire_prevention_documents',
                'capitation_fee_documents'
            ]));

            if ($fireNoObjection) {
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $fireNoObjection->id . '/' . date('dmY');
                $fireNoObjection->application_no = $applicationNo;
                $fireNoObjection->save();

                $status = Status::create([
                    'service_id' => 183,
                    'department_id' => 7,
                    'table_id' => $fireNoObjection->id,
                    'user_id' => $user->id
                ]);


              $this->commonservice->store_approval_hierarchies($fireNoObjection, $user, $status);

            }

            DB::commit();
            return true;

        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error in FireNoObjectionController@store: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString()
            ]);
            return false;
        }
    }



    public function edit($id)
    {
        return FireNoObjection::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();

        try {
            // Find the existing record
            $fireNoObjection = FireNoObjection::findOrFail($id);
            // Handle file uploads and update original file names
            if ($request->hasFile('uploaded_applications')) {
                if ($fireNoObjection && Storage::exists($fireNoObjection->uploaded_application)) {
                    Storage::delete($fireNoObjection->uploaded_application);
                }
                $request['uploaded_application'] = $request->uploaded_applications->store('fire-department/no-objection');
            }
            if ($request->hasFile('no_dues_documents')) {
                if ($fireNoObjection && Storage::exists($fireNoObjection->no_dues_document)) {
                    Storage::delete($fireNoObjection->no_dues_document);
                }
                $request['no_dues_document'] = $request->no_dues_documents->store('fire-department/no-objection');
            }
            if ($request->hasFile('architect_application_documents')) {
                if ($fireNoObjection && Storage::exists($fireNoObjection->architect_application_document)) {
                    Storage::delete($fireNoObjection->architect_application_document);
                }
                $request['architect_application_document'] = $request->architect_application_documents->store('fire-department/no-objection');
            }
            if ($request->hasFile('fire_prevention_documents')) {
                if ($fireNoObjection && Storage::exists($fireNoObjection->fire_prevention_document)) {
                    Storage::delete($fireNoObjection->fire_prevention_document);
                }
                $request['fire_prevention_document'] = $request->fire_prevention_documents->store('fire-department/no-objection');
            }
            if ($request->hasFile('capitation_fee_documents')) {
                if ($fireNoObjection && Storage::exists($fireNoObjection->capitation_fee_document)) {
                    Storage::delete($fireNoObjection->capitation_fee_document);
                }
                $request['capitation_fee_document'] = $request->capitation_fee_documents->store('fire-department/no-objection');
            }
            $fireNoObjection->update($request->all());



            // code to send data to department
            // if ($request->hasFile('uploaded_applications')) {
            //     $request['uploaded_application'] = $this->curlAPiService->convertFileInBase64($request->file('uploaded_applications'));
            // } else {
            //     $request['uploaded_application'] = "";
            // }
            // if ($request->hasFile('no_dues_documents')) {
            //     $request['no_dues_document'] = $this->curlAPiService->convertFileInBase64($request->file('no_dues_documents'));
            // } else {
            //     $request['no_dues_document'] = "";
            // }
            // if ($request->hasFile('architect_application_documents')) {
            //     $request['architect_application_document'] = $this->curlAPiService->convertFileInBase64($request->file('architect_application_documents'));
            // } else {
            //     $request['architect_application_document'] = "";
            // }
            // if ($request->hasFile('fire_prevention_documents')) {
            //     $request['fire_prevention_document'] = $this->curlAPiService->convertFileInBase64($request->file('fire_prevention_documents'));
            // } else {
            //     $request['fire_prevention_document'] = "";
            // }
            // if ($request->hasFile('capitation_fee_documents')) {
            //     $request['capitation_fee_document'] = $this->curlAPiService->convertFileInBase64($request->file('capitation_fee_documents'));
            // } else {
            //     $request['capitation_fee_document'] = "";
            // }
            // $request['application_no'] = $fireNoObjection->application_no;
            // $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? Auth::user()->user_id : Auth::user()->id;
            // $newData = $request->except(['_token', 'id', 'application_documents', 'nodues_documents']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.water') . 'AapaleSarkarAPI/NewTaxation.asmx/RequestForUpdateNewTaxation', 'NewTaxation');

            // Decode JSON string to PHP array
            // $data = json_decode($data, true);

            // if ($data['d']['Status'] == "200") {
            // Access the application_no
            DB::commit();
            return true;
            // } else {
            //     DB::rollback();
            //     return false;
            // }
            // end of code to send data to department
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return false;
        }
    }
}
