<?php

namespace App\Services\InsuranceofBirth;

use App\Http\Controllers\InsuranceOfBirthController\InsuranceOfDeathReadingController;
use App\Models\InsuranceOfBirthCertificate\InsuranceDeath;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;
use App\Services\CommonService;

class InsuranceOfDeathService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService,  CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    // public function store($request)
    // {

    //     $request['user_id'] = Auth::user()->id;
    //     $request['service_id'] = "6042";
    //     $request['application_no'] = "MBMCSWD-" . time();


    //     $completitioncertificate = CompletionCertificateDevelopment::create($request->all());

    //         if($completitioncertificate){

    //             Status::create([
    //                 'service_id' =>6042,
    //                 'department_id' =>4,
    //                 'table_id' => $completitioncertificate->id
    //             ]);
    //         }


    public function store(Request $request)
    {
        $data = $request->all();
        $user = Auth::user();
        $data['user_id'] = Auth::user()->id;
        $data['service_id'] = "8925";

        $fileFields = [
            'uploaded_applications'              => 'uploaded_application',
        ];
        if ($request->has('pincode')){
            $data['pincode_no'] = $request->pincode;
        }

        foreach ($fileFields as $input => $column) {
            if ($request->hasFile($input)) {
                $data[$column] = $request->file($input)->store('DeathDetails/death', 'public');
            }
        }

        $filteredData = collect($data)->except(['application_no', 'pincode'])->toArray();

        $grantingTelecom = InsuranceDeath::create($filteredData);
        if ($grantingTelecom) {
            $applicationNo = 'MBMC/' . $data['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

            $status =  Status::create([
                'service_id' => 8925,
                'department_id' => 1,
                'table_id' => $grantingTelecom->id,
                'user_id' => Auth::user()->id
            ]);

            $this->commonservice->store_approval_hierarchies($grantingTelecom, $user, $status);
        }

        // if ($grantingTelecom) {
        //     $applicationId = $request->application_no;

        //     if (Auth::user()->is_aapale_sarkar_user) {
        //         $aapaleSarkarCredential = ServiceCredential::where('dept_service_id', $request->service_id)->first();
        //         $serviceDay = ($aapaleSarkarCredential->service_day) ? $aapaleSarkarCredential->service_day : 20;

        //         $send = $this->aapaleSarkarLoginCheckService->encryptAndSendRequestToAapaleSarkar(
        //             Auth::user()->trackid,
        //             $aapaleSarkarCredential->client_code,
        //             Auth::user()->user_id,
        //             $aapaleSarkarCredential->service_id,
        //             $applicationId,
        //             'N',
        //             'NA',
        //             'N',
        //             'NA',
        //             $serviceDay,
        //             date('Y-m-d', strtotime("+$serviceDay days")),
        //             config('rtsapiurl.amount'),
        //             config('rtsapiurl.requestFlag'),
        //             config('rtsapiurl.applicationStatus'),
        //             config('rtsapiurl.applicationPendingStatusTxt'),
        //             $aapaleSarkarCredential->ulb_id,
        //             $aapaleSarkarCredential->ulb_district,
        //             'NA',
        //             'NA',
        //             'NA',
        //             $aapaleSarkarCredential->check_sum_key,
        //             $aapaleSarkarCredential->str_key,
        //             $aapaleSarkarCredential->str_iv,
        //             $aapaleSarkarCredential->soap_end_point_url,
        //             $aapaleSarkarCredential->soap_action_app_status_url
        //         );

        //         if (!$send) {
        //             $this->aapaleSarkarLoginCheckService->savePendingAapaleSarkarData($applicationId, $request->service_id, Auth::user()->user_id);
        //             DB::commit();
        //             return [true];
        //         }
        //     }
        // } else {
        //     DB::rollback();
        //     return [false, 'Something went wrong, please try again!'];
        // }

        DB::commit();
        return [true];

        // } catch (\Exception $e) {
        //     DB::rollback();
        //     Log::error('Error in store method: ' . $e->getMessage());
        //     return [false, $e->getMessage()];
        // }
    }

    public function edit($id)
    {
        return InsuranceDeath::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $insuranceofdeathreading = InsuranceDeath::find($id);

            // Handle file uploads and update original file names

            $insuranceofdeathreading->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
