<?php

namespace App\Services\MedicalHealth;

use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\MedicalHealth\GutterCover;
use App\Models\ServiceCredential;
use App\Models\Status;

class GutterCoverService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService  , CommonService  $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "8932";


          if ($request->hasFile('gpsphotos')) {
                $request['gpsphoto'] = $request->gpsphotos->store('MedicalHealth/guttercover','public');
            }

              if ($request->hasFile('upload_prescribed_formats')) {
                $request['prescribed_docs'] = $request->upload_prescribed_formats->store('MedicalHealth/potholes','public');
            }


        $grantNursingLicense=GutterCover::create($request->except('application_no'));

         if($grantNursingLicense){
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantNursingLicense->id . '/' . date('dmY');
                $grantNursingLicense->application_no = $applicationNo;
                $grantNursingLicense->save();



                $status = Status::create([
                    'service_id' => 8932,
                    'department_id' =>10,
                    'table_id' => $grantNursingLicense->id,
                    'user_id' => Auth::user()->id
                ]);

                  $this->commonservice->store_approval_hierarchies($grantNursingLicense, Auth::user(), $status);
            }



        DB::commit();
        return [true];

        // } catch (\Exception $e) {
        //     DB::rollback();
        //     Log::error('Error in store method: ' . $e->getMessage());
        //     return [false, $e->getMessage()];
        // }
    }

    public function edit($id)
    {
        return GutterCover::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $grantNursingLicense = GutterCover::find($id);
             $status_id = $grantNursingLicense->statuses()
                ->where('service_id', $grantNursingLicense->service_id)
                ->first()?->id;

               if ($request->hasFile('completion_photo')) {
                $request['completion_photos'] = $request->completion_photo->store('MedicalHealth/potholes','public');
            }

            $grantNursingLicense->update($request->all());
             if ( $grantNursingLicense->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
