<?php

namespace App\Services\Pwd;

use App\Models\PwdElectrical\CompletionCertificateDevelopment;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;



class CompletitionCertificateDevelopmentService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    // public function store($request)
    // {

    //     $request['user_id'] = Auth::user()->id;
    //     $request['service_id'] = "6042";
    //     $request['application_no'] = "MBMCSWD-" . time();


    //     $completitioncertificate = CompletionCertificateDevelopment::create($request->all());

    //         if($completitioncertificate){

    //             Status::create([
    //                 'service_id' =>6042,
    //                 'department_id' =>4,
    //                 'table_id' => $completitioncertificate->id
    //             ]);
    //         }


    public function store(Request $request)
    {
        // dd($request->all());
        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "6042";

         if ($request->hasFile('work_order_docs')) {
                $request['work_order_doc'] = $request->file('work_order_docs')
                    ->store('pwd_electrical', 'public');
            }

              if ($request->hasFile('work_completition_certificates')) {
                $request['work_completition_certificate'] = $request->file('work_completition_certificates')
                    ->store('pwd_electrical', 'public');
            }

              if ($request->hasFile('prescribed_doc')) {
                $request['prescribed_docs'] = $request->file('prescribed_doc')
                    ->store('pwd_electrical', 'public');
            }



        $grantingTelecom = CompletionCertificateDevelopment::create($request->except('application_no'));
        if($grantingTelecom){

               $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();


              $status =  Status::create([
                    'service_id' =>6042,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                    'user_id' => Auth::user()->id
                ]);

                $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);
            }


        DB::commit();
        return [true];

        // } catch (\Exception $e) {
        //     DB::rollback();
        //     Log::error('Error in store method: ' . $e->getMessage());
        //     return [false, $e->getMessage()];
        // }
    }

    public function edit($id)
    {
        return CompletionCertificateDevelopment::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $completitioncertificate = CompletionCertificateDevelopment::find($id);
             $status_id =  $completitioncertificate->statuses()
                ->where('service_id',  $completitioncertificate->service_id)
                ->first()?->id;
         

            if ($request->hasFile('upload_photos')) {
                $originalPhotoName = $request->file('upload_photos')->getClientOriginalName();
                $photoPath = $request->file('upload_photos')->storeAs("pwd_electrical/upload_photos/", $originalPhotoName, 'public');
                $request['upload_photo'] = $photoPath;
            }

            if ($request->hasFile('upload_reports')) {
                $originalReportName = $request->file('upload_reports')->getClientOriginalName();
                $reportPath = $request->file('upload_reports')->storeAs("pwd_electrical/upload_reports/", $originalReportName, 'public');
                $request['upload_report'] = $reportPath;
            }

             if ($request->hasFile('geotag')) {
                $originalReportName = $request->file('geotag')->getClientOriginalName();
                $reportPath = $request->file('geotag')->storeAs("pwd_electrical/geotag/", $originalReportName, 'public');
                $request['geotags'] = $reportPath;
            }

            $completitioncertificate->update($request->except(['upload_photos', 'upload_reports']));

             if ( $completitioncertificate->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
