<?php

namespace App\Services\Pwd;

// use App\Models\PwdElectrical\DevelopmentWorksQuantity;
use App\Models\PwdElectrical\DevelopmentWorksQuantity;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;



class DevelopmentWorkQuantityService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService  $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store(Request $request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "7042";

         if ($request->hasFile('work_order_docs')) {
                $request['work_order_doc'] = $request->work_order_docs->store('work/quantity', 'public');
            }

              if ($request->hasFile('work_completition_docs')) {
                $request['work_completition_doc'] = $request->work_completition_docs->store('work/quantity', 'public');
            }

              if ($request->hasFile('prescribed_doc')) {
                $request['prescribed_docs'] = $request->prescribed_doc->store('work/quantity', 'public');
            }


       $grantingTelecom = DevelopmentWorksQuantity::create($request->except('application_no'));

       if($grantingTelecom){

                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
                $grantingTelecom->application_no = $applicationNo;
                $grantingTelecom->save();

               $status= Status::create([
                    'service_id' =>7042,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                    'user_id'  => Auth::user()->id
                ]);

                  $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

            }



        DB::commit();
        return [true];


    }

    public function edit($id)
    {
        return DevelopmentWorksQuantity::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $completitioncertificate = DevelopmentWorksQuantity::find($id);

            $status_id = $completitioncertificate->statuses()->where('service_id', $completitioncertificate->service_id)->first()?->id;

             if ($request->hasFile('work_completition_doc')) {
                if ($completitioncertificate->work_completition_doc && Storage::exists($completitioncertificate->work_completition_doc)) {
                    Storage::delete($completitioncertificate->work_completition_doc);
                }
                $request['work_completition_do'] = $request->work_completition_doc->store('workorder/quantity', 'public');
            }

              if ($request->hasFile('work_order_doc')) {
                if ($completitioncertificate->work_order_dos && Storage::exists($completitioncertificate->work_order_dos)) {
                    Storage::delete($completitioncertificate->work_order_doc);
                }
                $request['work_order_do'] = $request->work_order_do->store('workorder/quantity', 'public');
            }



            if ($request->hasFile('upload_photos')) {
                $originalPhotoName = $request->file('upload_photos')->getClientOriginalName();
                $photoPath = $request->file('upload_photos')->storeAs("pwd_electrical/upload_photos/", $originalPhotoName, 'public');
                $request['upload_photo'] = $photoPath;
            }

            if ($request->hasFile('upload_reports')) {
                $originalReportName = $request->file('upload_reports')->getClientOriginalName();
                $reportPath = $request->file('upload_reports')->storeAs("pwd_electrical/upload_reports/", $originalReportName, 'public');
                $request['upload_report'] = $reportPath;
            }

             if ($request->hasFile('geotag')) {
                $originalReportName = $request->file('geotag')->getClientOriginalName();
                $reportPath = $request->file('geotag')->storeAs("pwd_electrical/geotag/", $originalReportName, 'public');
                $request['geotags'] = $reportPath;
            }



            $completitioncertificate->update($request->all());

            if ($completitioncertificate->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
