<?php

namespace App\Services\Pwd;

use App\Models\PwdElectrical\PathRoadCitizenshipCertificate;
use App\Models\PwdElectrical\PrivateInfrastructureWorkPermission;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;



class PrivateInfrastructureService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    // public function store(Request $request)
    // {

    //     $request['user_id'] = Auth::user()->id;
    //     $request['service_id'] = "4042";
    //     $request['application_no'] = "MBMCSWD-" . time();


    //     $privateinfrastructure = PrivateInfrastructureWorkPermission::create($request->all());

    //         if($privateinfrastructure){

    //             Status::create([
    //                 'service_id' =>4042,
    //                 'department_id' =>4,
    //                 'table_id' => $privateinfrastructure->id
    //             ]);
    //         }


        public function store(Request $request)
        {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "4042";


        $documentFields = [
            'side_visit_geotag_pic',
            'property_doc',
            'plan_copy',
            'prescribed_doc'
        ];
        foreach ($documentFields as $field) {
            $formField = $field . 's';
            if ($request->hasFile($formField)) {
                $originalFileName = $request->file($formField)->getClientOriginalName();
                $request[$field] = $request->file($formField)->storeAs("pwd_electrical/$formField/", $originalFileName, 'public');
            }
        }

        $grantingTelecom = PrivateInfrastructureWorkPermission::create($request->except('application_no'));

        if ($grantingTelecom) {
            $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

          $status = Status::create([
                'service_id' => 4042,
                'department_id' => 10,
                'table_id' => $grantingTelecom->id,
                'user_id' => Auth::user()->id
            ]);
            $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

        }


        DB::commit();
        return [true];


    }

// public function store(Request $request)
// {
//     DB::beginTransaction();

//     try {
//         $requestData = $request->all(); // copy request data

//         $requestData['user_id'] = Auth::id();
//         $requestData['service_id'] = 4042;

//         $documentFields = [
//             'side_visit_geotag_pic',
//             'property_doc',
//             'plan_copy',
//             'prescribed_docs'
//         ];

//         foreach ($documentFields as $field) {
//             if ($request->hasFile($field)) {
//                 $originalName = pathinfo($request->file($field)->getClientOriginalName(), PATHINFO_FILENAME);
//                 $extension = $request->file($field)->getClientOriginalExtension();
//                 $uniqueFileName = $originalName . '_' . time() . '.' . $extension;

//                 $path = $request->file($field)->storeAs("pwd_electrical/$field", $uniqueFileName, 'public');

//                 // IMPORTANT: Save the storage path in $requestData, not $request
//                 $requestData[$field] = $path;
//             }
//         }

//         // Save to DB
//         $grantingTelecom = PrivateInfrastructureWorkPermission::create($requestData);

//         if ($grantingTelecom) {
//             $applicationNo = 'MBMC/' . $requestData['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
//             $grantingTelecom->update(['application_no' => $applicationNo]);

//             $status = Status::create([
//                 'service_id' => 4042,
//                 'department_id' => 10,
//                 'table_id' => $grantingTelecom->id,
//                 'user_id' => Auth::id()
//             ]);

//             $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);
//         }

//         DB::commit();
//         return [true];

//     } catch (\Exception $e) {
//         DB::rollBack();
//         return response()->json(['error' => $e->getMessage()], 500);
//     }
// }





    public function edit($id)
    {
        return PrivateInfrastructureWorkPermission::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $privateinfrastructure = PrivateInfrastructureWorkPermission::find($id);

            // Handle file uploads and update original file names

            $privateinfrastructure->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
