<?php

namespace App\Services\Pwd;

use App\Models\PwdElectrical\StromWaterDrain;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;



class StromWaterDrainsService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService ,CommonService  $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    // public function store($request)
    // {

    //     $request['user_id'] = Auth::user()->id;
    //     $request['service_id'] = "2042";
    //     $request['application_no'] = "MBMCSWD-" . time();


        // $stromwaterdrain=StromWaterDrain::create($request->all());

        //     if($stromwaterdrain){

        //         Status::create([
        //             'service_id' =>2042,
        //             'department_id' =>4,
        //             'table_id' => $stromwaterdrain->id
        //         ]);


        // $documentFields = [
        //     'survery_plan_doc',
        //     'side_visit_doc',
        //     'property_doc',

        // ];

        // foreach ($documentFields as $field) {
        //     $formField = $field . 's'; // expects input name like 'lease_agreements'
        //     if ($request->hasFile($formField)) {
        //         $originalFileName = $request->file($formField)->getClientOriginalName();

        //         $request[$field] = $request->file($formField)->storeAs("pwd_electrical/$formField/", $originalFileName, 'public');
        //     }
        // }

        public function store(Request $request)
        {
            $request->merge([
                'user_id' => Auth::user()->id,
                'service_id' => "2042"
            ]);

              if ($request->hasFile('plan_copys')) {
                $request['plan_copy'] = $request->file('plan_copys')
                    ->store('pwd_electrical', 'public');
            }

               if ($request->hasFile('side_visit_geotag_pics')) {
                $request['side_visit_geotag_pic'] = $request->file('side_visit_geotag_pics')
                    ->store('pwd_electrical', 'public');
            }
              if ($request->hasFile('property_docs')) {
                $request['property_doc'] = $request->file('property_docs')
                    ->store('pwd_electrical', 'public');
            }

               if ($request->hasFile('prescribed_doc')) {
                $request['prescribed_docs'] = $request->file('prescribed_doc')
                    ->store('pwd_electrical', 'public');
            }



            $grantingTelecom = StromWaterDrain::create($request->except('application_no'));
            if($grantingTelecom){
            $applicationNo = 'MBMC/' . $request->input('service_id') . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

          $status = Status::create([
                'service_id' => 2042,
                'department_id' => 17,
                'table_id' => $grantingTelecom->id,
                'user_id' => Auth::user()->id
            ]);

            $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

        }
          DB::commit();
        return [true];
    }

    public function edit($id)
    {
        return StromWaterDrain::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $stronwaterdrain = StromWaterDrain::find($id);

            // Handle file uploads and update original file names

            $stronwaterdrain->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
