<?php

namespace App\Services\Pwd;

use App\Models\PwdElectrical\WindBlow;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;



class WindBlowService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService  $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store(Request $request)
    {

        $user = Auth::user();
        $request->merge([
            'user_id' => Auth::user()->id,
            'service_id' => "9397"
        ]);

        if ($request->hasFile('cc_oc_certificate')) {
            $request['cc_oc_certificates'] = $request->cc_oc_certificate->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('fire_noc')) {
            $request['fire_nocs'] = $request->fire_noc->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('solid_waste_noc')) {
            $request['solid_waste_nocs'] = $request->solid_waste_noc->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('structural_stability_certificate')) {
            $request['structural_stability_certificates'] = $request->structural_stability_certificate->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('electrical_safety_certificate')) {
            $request['electrical_safety_certificates'] = $request->electrical_safety_certificate->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('water_supply_sewage_noc')) {
            $request['water_supply_sewage_nocs'] = $request->water_supply_sewage_noc->store('pwd/windblow', 'public');
        }

        if ($request->hasFile('prabhag_office_noc')) {
            $request['prabhag_office_nocs'] = $request->prabhag_office_noc->store('pwd/windblow', 'public');
        }
          if ($request->hasFile('school_gps_photo')) {
            $request['school_gps_photos'] = $request->school_gps_photo->store('pwd/windblow', 'public');
        }

         if ($request->hasFile('upload_prescribed_format')) {
            $request['upload_prescribeds'] = $request->upload_prescribed_format->store('pwd/windblow', 'public');
        }


        $grantingTelecom = WindBlow::create($request->except('application_no'));

        if ($grantingTelecom) {
            $applicationNo = 'MBMC/' . $request->input('service_id') . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

            $status = Status::create([
                'service_id' => 9397,
                'department_id' => 10,
                'table_id' => $grantingTelecom->id,
                'user_id' => Auth::user()->id
            ]);

         $this->commonservice->store_approval_hierarchies($grantingTelecom, $user, $status);


        }
        DB::commit();
        return [true];
    }

    public function edit($id)
    {
        return WindBlow::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $stronwaterdrain = WindBlow::find($id);
            $stronwaterdrain->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
