<?php

namespace App\Services\PwdElectrical;

use App\Models\PwdElectrical\SarvajanikJagetunJanaraRastyachaDakhla;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use App\Models\Status;


class SarvajanikService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }



    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "9041";

        $documentFields = [
            'survery_plan_doc',
            'side_visit_doc',
            'property_doc',

        ];

        if ($request->hasFile('survery_plan_docs')) {
                $request['survery_plan_doc'] = $request->file('survery_plan_docs')->store('sarvajnik-jagetun', 'public');
        }
        if ($request->hasFile('side_visit_docs')) {
            $request['side_visit_doc'] = $request->file('side_visit_docs')->store('sarvajnik-jagetun', 'public');
        }
        if ($request->hasFile('property_docs')) {
            $request['property_doc'] = $request->file('property_docs')->store('sarvajnik-jagetun', 'public');
        }
        if ($request->hasFile('prescribed_doc')) {
            $request['prescribed_docs'] = $request->file('prescribed_doc')->store('sarvajnik-jagetun', 'public');
        }


        $grantingTelecom = SarvajanikJagetunJanaraRastyachaDakhla::create($request->except('application_no'));

            if($grantingTelecom){
            $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();


             $status= Status::create([
                    'service_id' =>9041,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                      'user_id' => Auth::user()->id
                ]);

                $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

            }


        DB::commit();
        return [true];

    }



    public function edit($id)
    {
        return SarvajanikJagetunJanaraRastyachaDakhla::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();

        try {
            $record = SarvajanikJagetunJanaraRastyachaDakhla::findOrFail($id);
               $status_id =  $record->statuses()
                ->where('service_id',  $record->service_id)
                ->first()?->id;

            if ($request->hasFile('geotag')) {
                $file = $request->file('geotag');
                $originalName = $file->getClientOriginalName();
                $path = $file->storeAs('sarvajanik/thakbaki', $originalName, 'public');

                $request->merge(['geotags' => $path]);
            }

            $record->update($request->all());
             if ( $record ->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];

        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update failed: ' . $e->getMessage(), [
                'exception' => $e,
                'request_data' => $request->all()
            ]);
            return [false, $e->getMessage()];
        }
    }
}
