<?php

namespace App\Services\Pwd;

use App\Models\PwdElectrical\StromWaterDrain;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\Status;

class StromWaterDrainsService
{
    protected $aapaleSarkarLoginCheckService;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
    }


    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "2042";

        $grantingTelecom = StromWaterDrain::create($request->except('application_no'));

        if($grantingTelecom){

            $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

               $status = Status::create([
                    'service_id' =>2042,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                    'user_id' => Auth::user()->id
                ]);

                 $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);
            }



        DB::commit();
        return [true];


    }

    public function edit($id)
    {
        return StromWaterDrain::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $stronwaterdrain = StromWaterDrain::find($id);

            // Handle file uploads and update original file names

            $stronwaterdrain->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
