<?php

namespace App\Services\PwdElectrical;

use App\Models\PwdElectrical\VibhagakadeThakbakiNaslyachePramanpatra;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Services\AapaleSarkarLoginCheckService;
use App\Services\CommonService;
use App\Models\Status;


class VibhagThakbakiNaslyachePramanpatraService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }



    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "8042";

         if ($request->hasFile('adhaar_card')) {
                $request['adhaar_cards'] = $request->file('adhaar_card')
                    ->store('vibhag/thakbaki', 'public');
            }
             if ($request->hasFile('prescribed_doc')) {
                $request['prescribed_docs'] = $request->file('prescribed_doc')
                    ->store('vibhag/thakbaki', 'public');
            }

        $grantingTelecom = VibhagakadeThakbakiNaslyachePramanpatra::create($request->except('application_no'));

            if($grantingTelecom){
            $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $grantingTelecom->id . '/' . date('dmY');
            $grantingTelecom->application_no = $applicationNo;
            $grantingTelecom->save();

             $status =  Status::create([
                    'service_id' =>8042,
                    'department_id' =>10,
                    'table_id' => $grantingTelecom->id,
                    'user_id' => Auth::user()->id
                ]);
                 $this->commonservice->store_approval_hierarchies($grantingTelecom, Auth::user(), $status);

            }


        DB::commit();
        return [true];

    }



    public function edit($id)
    {
        return VibhagakadeThakbakiNaslyachePramanpatra::find($id);
    }

   public function update($request, $id)
    {
        DB::beginTransaction();

        try {
            $record = VibhagakadeThakbakiNaslyachePramanpatra::findOrFail($id);
             $status_id =  $record->statuses()
                ->where('service_id',  $record->service_id)
                ->first()?->id;

            if ($request->hasFile('geotag')) {
                $file = $request->file('geotag');
                $originalName = $file->getClientOriginalName();
                $path = $file->storeAs('vibhag/thakbaki', $originalName, 'public');

                $request->merge(['geotags' => $path]);
            }
            

            $record->update($request->all());

             if ( $record ->wasChanged('ward_area') && $status_id) {
                $resetResponse = $this->commonservice->reset_next_approvers($status_id)->getData(true);

                if (isset($resetResponse['status']) && $resetResponse['status'] === false) {
                    DB::rollBack();
                    return [
                        'status' => false,
                        'message' => $resetResponse['message'] ,
                    ];
                }
            }

            DB::commit();
            return [true];

        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Update failed: ' . $e->getMessage(), [
                'exception' => $e,
                'request_data' => $request->all()
            ]);
            return [false, $e->getMessage()];
        }
    }
}
