<?php

namespace App\Services\Trade;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\Trade\TradeChangeOwnerName;
use App\Models\ServiceCredential;
use App\Services\CurlAPiService;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Status;
class ChangeOwnerNameService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "36";
            // Handle file uploads and store original file names
            if ($request->hasFile('no_dues_documents')) {
                $request['no_dues_document'] = $request->no_dues_documents->store('trade/change-owner-name');
            }
            if ($request->hasFile('application_documents')) {
                $request['application_document'] = $request->application_documents->store('trade/change-owner-name');
            }
            $tradeChangeOwnerName = TradeChangeOwnerName::create($request->except('application_no'));
            if($tradeChangeOwnerName){
                       $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $tradeChangeOwnerName->id . '/' . date('dmY');
                $tradeChangeOwnerName->application_no = $applicationNo;
                $tradeChangeOwnerName->save();
                 Status::create([
                    'service_id' => 36,
                    'department_id' =>4,
                    'table_id' => $tradeChangeOwnerName->id,
                    'ward_area' => $tradeChangeOwnerName->ward_area
                ]);
            }

            // // code to send data to department
            // if ($request->hasFile('application_documents')) {
            //     $request['application_document'] = $this->curlAPiService->convertFileInBase64($request->file('application_documents'));
            // } else {
            //     $request['application_document'] = "";
            // }
            // if ($request->hasFile('no_dues_documents')) {
            //     $request['no_dues_document'] = $this->curlAPiService->convertFileInBase64($request->file('no_dues_documents'));
            // } else {
            //     $request['no_dues_document'] = "";
            // }
            // $request['user_id'] =  (Auth::user()->user_id && Auth::user()->user_id != "") ? "" . Auth::user()->user_id . "" : "" . Auth::user()->id . "";
            // $newData = $request->except(['_token', 'application_documents', 'no_dues_documents']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.trade') . 'SHELMicroService/SHELApi/ApleSarkarService/AddPartnerNameChangeFORPMC', '');

            // // Decode JSON string to PHP array
            // $data = json_decode($data, true);
            // if (isset($data['status']) && $data['status'] == "200") {
            //     // Access the application_no
            //     $applicationId = $data['applicationId'];
            //     TradeChangeOwnerName::where('id', $tradeChangeOwnerName->id)->update([
            //         'application_no' => $applicationId
            //     ]);

            //     if (Auth::user()->is_aapale_sarkar_user) {
            //         $aapaleSarkarCredential = ServiceCredential::where('dept_service_id', $request->service_id)->first();
            //         $serviceDay = ($aapaleSarkarCredential->service_day) ? $aapaleSarkarCredential->service_day : 20;

            //         $send = $this->aapaleSarkarLoginCheckService->encryptAndSendRequestToAapaleSarkar(Auth::user()->trackid, $aapaleSarkarCredential->client_code, Auth::user()->user_id, $aapaleSarkarCredential->service_id, $applicationId, 'N', 'NA', 'N', 'NA', $serviceDay, date('Y-m-d', strtotime("+$serviceDay days")), config('rtsapiurl.amount'), config('rtsapiurl.requestFlag'), config('rtsapiurl.applicationStatus'), config('rtsapiurl.applicationPendingStatusTxt'), $aapaleSarkarCredential->ulb_id, $aapaleSarkarCredential->ulb_district, 'NA', 'NA', 'NA', $aapaleSarkarCredential->check_sum_key, $aapaleSarkarCredential->str_key, $aapaleSarkarCredential->str_iv, $aapaleSarkarCredential->soap_end_point_url, $aapaleSarkarCredential->soap_action_app_status_url);

            //         if (!$send) {
            //             $this->aapaleSarkarLoginCheckService->savePendingAapaleSarkarData($applicationId, $request->service_id, Auth::user()->user_id);
            //             DB::commit();
            //             return [true];
            //         }
            //     }
            //     // $subject = "Testing Subject";
            //     // $message = "Testing Message";
            //     // Mail::to($request->email_id)->send(new SendMail($subject, $message));
            // } else {
            //     DB::rollback();
            //     return [false, $data['error']];
            // }
            // end of code to send data to department

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in store method: ' . $e->getMessage());
            return [false, $e->getMessage()];
        }
    }


    public function edit($id)
    {
        return TradeChangeOwnerName::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();

        try {

            // Find the existing record
            $tradeChangeOwnerName = TradeChangeOwnerName::findOrFail($id);
            // Handle file uploads and update original file names
            if ($request->hasFile('no_dues_documents')) {
                if ($tradeChangeOwnerName && Storage::exists($tradeChangeOwnerName->no_dues_document)) {
                    Storage::delete($tradeChangeOwnerName->no_dues_document);
                }
                $request['no_dues_document'] = $request->no_dues_documents->store('trade/change-owner-name');
            }
            if ($request->hasFile('application_documents')) {
                if ($tradeChangeOwnerName && Storage::exists($tradeChangeOwnerName->application_document)) {
                    Storage::delete($tradeChangeOwnerName->application_document);
                }
                $request['application_document'] = $request->application_documents->store('trade/change-owner-name');
            }
            $tradeChangeOwnerName->update($request->all());


            // code to send data to department
            if ($request->hasFile('application_documents')) {
                $request['application_document'] = $this->curlAPiService->convertFileInBase64($request->file('application_documents'));
            } else {
                $request['application_document'] = "";
            }
            if ($request->hasFile('no_dues_documents')) {
                $request['no_dues_document'] = $this->curlAPiService->convertFileInBase64($request->file('no_dues_documents'));
            } else {
                $request['no_dues_document'] = "";
            }
            $request['application_no'] = $tradeChangeOwnerName->application_no;
            $request['user_id'] =  (Auth::user()->user_id && Auth::user()->user_id != "") ? "" . Auth::user()->user_id . "" : "" . Auth::user()->id . "";
            $newData = $request->except(['_token', 'id', 'application_documents', 'no_dues_documents']);
            $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.trade') . 'SHELMicroService/SHELApi/ApleSarkarService/UpdatePartnerNameChangeFORPMC', '');

            // Decode JSON string to PHP array
            $data = json_decode($data, true);

            if (isset($data['status']) && $data['status'] == "200") {
                // Access the application_no
                DB::commit();
                return [true];
            } else {
                DB::rollback();
                return [false, $data['error']];
            }
            // end of code to send data to department
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
