<?php

namespace App\Services\Trade;

use App\Mail\SendMail;
use App\Models\Status;
use App\Services\CommonService;
use App\Services\CurlAPiService;
use App\Models\ServiceCredential;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use App\Models\Trade\TradeLicenseCancellation;
use App\Services\AapaleSarkarLoginCheckService;

class LicenseCancellationService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "41";
            if ($request->hasFile('application_documents')) {
                $request['application_document'] = $request->application_documents->store('trade/license-cancellation');
            }
            if ($request->hasFile('prescribed_docs')) {
                $request['prescribed_doc'] = $request->prescribed_docs->store('trade/license-cancellation');
            }
            $tradeLicenseCancellation = TradeLicenseCancellation::create($request->except('application_no'));

             if($tradeLicenseCancellation){
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $tradeLicenseCancellation->id . '/' . date('dmY');
                $tradeLicenseCancellation->application_no = $applicationNo;
                $tradeLicenseCancellation->save();

            $status = Status::create([
                    'service_id' => 41,
                    'department_id' =>6,
                    'table_id' => $tradeLicenseCancellation->id,
                    'user_id' => Auth::user()->id
                ]);

               $this->commonservice->store_approval_hierarchies($tradeLicenseCancellation, Auth::user(), $status);

            }



            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in store method: ' . $e->getMessage());
            return [false, $e->getMessage()];
        }
    }


    public function edit($id)
    {
        return TradeLicenseCancellation::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();

        try {
            // Find the existing record
            $tradeLicenseCancellation = TradeLicenseCancellation::findOrFail($id);
            // Handle file uploads and update original file names
            if ($request->hasFile('application_documents')) {
                if ($tradeLicenseCancellation && Storage::exists($tradeLicenseCancellation->application_document)) {
                    Storage::delete($tradeLicenseCancellation->application_document);
                }
                $request['application_document'] = $request->application_documents->store('trade/license-cancellation');
            }
            $tradeLicenseCancellation->update($request->all());


            // code to send data to department
            if ($request->hasFile('application_documents')) {
                $request['application_document'] = $this->curlAPiService->convertFileInBase64($request->file('application_documents'));
            } else {
                $request['application_document'] = "";
            }
            $request['application_no'] = $tradeLicenseCancellation->application_no;
            $request['user_id'] =  (Auth::user()->user_id && Auth::user()->user_id != "") ? "" . Auth::user()->user_id . "" : "" . Auth::user()->id . "";
            $newData = $request->except(['_token', 'id', 'application_documents']);
            $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.trade') . 'SHELMicroService/SHELApi/ApleSarkarService/UpdateCancellationLiecenseFORPMC', '');

            // Decode JSON string to PHP array
            $data = json_decode($data, true);

            if (isset($data['status']) && $data['status'] == "200") {
                // Access the application_no
                DB::commit();
                return [true];
            } else {
                DB::rollback();
                return [false, $data['error']];
            }
            // end of code to send data to department

        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
