<?php

namespace App\Services\Trade;

use App\Models\Status;
use App\Services\CommonService;
use App\Models\ServiceCredential;
use Illuminate\Support\Facades\DB;
use App\Models\Trade\MovieShooting;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Trade\LicenseLoadgingHouse;
use App\Services\AapaleSarkarLoginCheckService;

class MovieShootingService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService , CommonService $commonservice )
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "2034";


         if ($request->hasFile('prescribed_docs')) {
                $request['prescribed_doc'] = $request->prescribed_docs->store('trade/movieshooting','public');
            }

        $movieshooting=MovieShooting::create($request->except('application_no'));
            if($movieshooting){
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $movieshooting->id . '/' . date('dmY');
                $movieshooting->application_no = $applicationNo;
                $movieshooting->save();

                       $status = Status::create([
                                'service_id' =>2034,
                                'department_id' =>6,
                                'table_id' => $movieshooting->id,
                                'user_id' => Auth::user()->id
                            ]);
                  $this->commonservice->store_approval_hierarchies($movieshooting, Auth::user(), $status);
                        }



        DB::commit();
        return [true];

    }

    public function edit($id)
    {
        return MovieShooting::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $movieshooting = MovieShooting::find($id);

            // Handle file uploads and update original file names

            $movieshooting->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
