<?php

namespace App\Services\Trade;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\Trade\TradeNocForMandap;
use App\Models\ServiceCredential;
use App\Services\CurlAPiService;
use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Status;
use App\Services\CommonService;

class NocForMandapService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService ,CommonService $commonservice)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $user=Auth::User();
            $data = $request->except(['application_no']);
            $data['user_id'] = Auth::id();
            $data['service_id'] = 37;

            if ($request->hasFile('board_registration_documents')) {
                $data['board_registration_document'] = $request->file('board_registration_documents')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('no_objection_documents')) {
                $data['no_objection_document'] = $request->file('no_objection_documents')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('location_map_documents')) {
                $data['location_map_document'] = $request->file('location_map_documents')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('fire_last_year_noObjection_documents')) {
                $data['fire_last_year_noObjection_document'] = $request->file('fire_last_year_noObjection_documents')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('traffic_last_year_noObjection_documents')) {
                $data['traffic_last_year_noObjection_document'] = $request->file('traffic_last_year_noObjection_documents')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('prescribed_docs')) {
                $data['prescribed_doc'] = $request->file('prescribed_docs')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('annexures')) {
                $data['annexure'] = $request->file('annexures')->store('trade/noc-for-mandap', 'public');
            }
            if ($request->hasFile('location_map_documents')) {
                $data['location_map_documents'] = $request->file('location_map_documents')->store('trade/noc-for-mandap', 'public');
            }

            if ($request->hasFile('mandap_documents')) {
                $data['mandap_documents'] = $request->file('mandap_documents')->store('trade/noc-for-mandap', 'public');
            }

            if ($request->hasFile('local_polic_documents')) {
                $data['local_polic_documents'] = $request->file('local_polic_documents')->store('trade/noc-for-mandap', 'public');
            }




            $tradeNocForMandap = TradeNocForMandap::create($data);

            if ($tradeNocForMandap) {
                $applicationNo = 'MBMC/' . $data['service_id'] . '/' . $tradeNocForMandap->id . '/' . date('dmY');
                $tradeNocForMandap->application_no = $applicationNo;
                $tradeNocForMandap->save();

             $status =  Status::create([
                    'service_id' => 37,
                    'department_id' => 16,
                    'table_id' => $tradeNocForMandap->id,
                    'ward_area' => $tradeNocForMandap->ward_area,
                    'user_id'=>Auth::User()->id
                ]);
              $this->commonservice->store_approval_hierarchies($tradeNocForMandap, $user, $status);

            }

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error in store method: ' . $e->getMessage());
            return [false, $e->getMessage()];
        }
    }



    public function edit($id)
    {
        return TradeNocForMandap::find($id);
    }

//     public function update_old($request, $id)
//     {
//         DB::beginTransaction();

//         try {
            
//             $tradeNocForMandap = TradeNocForMandap::findOrFail($id);

         
//             if ($request->hasFile('board_registration_documents')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->board_registration_document)) {
//                     Storage::delete($tradeNocForMandap->board_registration_document);
//                 }
//                 $request['board_registration_document'] = $request->board_registration_documents->store('trade/noc-for-mandap');
//             }

//             if ($request->hasFile('no_objection_documents')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->no_objection_document)) {
//                     Storage::delete($tradeNocForMandap->no_objection_document);
//                 }
//                 $request['no_objection_document'] = $request->no_objection_documents->store('trade/noc-for-mandap');
//             }
//             if ($request->hasFile('location_map_documents')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->location_map_document)) {
//                     Storage::delete($tradeNocForMandap->location_map_document);
//                 }
//                 $request['location_map_document'] = $request->location_map_documents->store('trade/noc-for-mandap');
//             }
//             if ($request->hasFile('fire_last_year_noObjection_documents')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->fire_last_year_noObjection_document)) {
//                     Storage::delete($tradeNocForMandap->fire_last_year_noObjection_document);
//                 }
//                 $request['fire_last_year_noObjection_document'] = $request->fire_last_year_noObjection_documents->store('trade/noc-for-mandap');
//             }
//             if ($request->hasFile('traffic_last_year_noObjection_documents')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->traffic_last_year_noObjection_document)) {
//                     Storage::delete($tradeNocForMandap->traffic_last_year_noObjection_document);
//                 }
//                 $request['traffic_last_year_noObjection_document'] = $request->traffic_last_year_noObjection_documents->store('trade/noc-for-mandap');
//             }
//             if ($request->hasFile('annexures')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->annexure)) {
//                     Storage::delete($tradeNocForMandap->annexure);
//                 }
//                 $request['annexure'] = $request->annexures->store('trade/noc-for-mandap');
//             }
//             $tradeNocForMandap->update($request->all());

          
//             if ($request->hasFile('board_registration_documents')) {
//                 $request['board_registration_document'] = $this->curlAPiService->convertFileInBase64($request->file('board_registration_documents'));
//             } else {
//                 $request['board_registration_document'] = "";
//             }
//             if ($request->hasFile('no_objection_documents')) {
//                 $request['no_objection_document'] = $this->curlAPiService->convertFileInBase64($request->file('no_objection_documents'));
//             } else {
//                 $request['no_objection_document'] = "";
//             }
//             if ($request->hasFile('location_map_documents')) {
//                 $request['location_map_document'] = $this->curlAPiService->convertFileInBase64($request->file('location_map_documents'));
//             } else {
//                 $request['location_map_document'] = "";
//             }
//             if ($request->hasFile('fire_last_year_noObjection_documents')) {
//                 $request['fire_last_year_noObjection_document'] = $this->curlAPiService->convertFileInBase64($request->file('fire_last_year_noObjection_documents'));
//             } else {
//                 $request['fire_last_year_noObjection_document'] = "";
//             }
//             if ($request->hasFile('traffic_last_year_noObjection_documents')) {
//                 $request['traffic_last_year_noObjection_document'] = $this->curlAPiService->convertFileInBase64($request->file('traffic_last_year_noObjection_documents'));
//             } else {
//                 $request['traffic_last_year_noObjection_document'] = "";
//             }
//             if ($request->hasFile('annexures')) {
//                 $request['annexure'] = $this->curlAPiService->convertFileInBase64($request->file('annexures'));
//             } else {
//                 $request['annexure'] = "";
//             }



// //ksihroi start code //
//             if ($request->hasFile('agnishamak_javak_kramank')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->agnishamak_javak_kramank)) {
//                     Storage::delete($tradeNocForMandap->agnishamak_javak_kramank);
//                 }
//                 $request['agnishamak_javak_kramank'] = $request->agnishamak_javak_kramank->store('trade/noc-for-mandap');
//             }if ($request->hasFile('sambandhit_javak_kramank')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->sambandhit_javak_kramank)) {
//                     Storage::delete($tradeNocForMandap->sambandhit_javak_kramank);
//                 }
//                 $request['sambandhit_javak_kramank'] = $request->sambandhit_javak_kramank->store('trade/noc-for-mandap');
//             }if ($request->hasFile('stanikpolice_javak_kramank')) {
//                 if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->stanikpolice_javak_kramank)) {
//                     Storage::delete($tradeNocForMandap->stanikpolice_javak_kramank);
//                 }
//                 $request['stanikpolice_javak_kramank'] = $request->stanikpolice_javak_kramank->store('trade/noc-for-mandap');
//             }

//             $tradeNocForMandap->agnishamak_police_date = $request->input('agnishamak_police_date');
//             $tradeNocForMandap->stanikpolice_date = $request->input('stanikpolice_date');
//             $tradeNocForMandap->sambandhit_date = $request->input('sambandhit_date');
//             //ksihroi end code //


            





















//             $request['application_no'] = $tradeNocForMandap->application_no;
//             $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? "" . Auth::user()->user_id . "" : "" . Auth::user()->id . "";
//             $newData = $request->except(['_token', 'id', 'board_registration_documents', 'no_objection_documents', 'location_map_documents', 'fire_last_year_noObjection_documents', 'traffic_last_year_noObjection_documents', 'annexures']);
//             $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.trade') . 'SHELMicroService/SHELApi/ApleSarkarService/UpdateTempTentAllowFORPMC', '');

           
//             $data = json_decode($data, true);

//             if (isset($data['status']) && $data['status'] == "200") {
               
//                 DB::commit();
//                 return [true];
//             } else {
//                 DB::rollback();
//                 return [false, $data['error']];
//             }
            
//         } catch (\Exception $e) {
//             DB::rollback();
//             Log::info($e);
//             return [false, $e->getMessage()];
//         }
//     }



    //kishroi start the code//
    // public function update-old($request, $id)
    // {
    //     //dd($request->all());
    //     DB::beginTransaction();
    //     try {
    //          $tradeNocForMandap = TradeNocForMandap::findOrFail($id);

    //         //ksihroi start code //
    //         // if ($request->hasFile('agnishamak_javak_kramank')) {
    //         //     if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->agnishamak_javak_kramank)) {
    //         //         Storage::delete($tradeNocForMandap->agnishamak_javak_kramank);
    //         //     }
    //         //     $request['agnishamak_javak_kramank'] = $request->agnishamak_javak_kramank->store('trade/noc-for-mandap');
    //         // }if ($request->hasFile('sambandhit_javak_kramank')) {
    //         //     if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->sambandhit_javak_kramank)) {
    //         //         Storage::delete($tradeNocForMandap->sambandhit_javak_kramank);
    //         //     }
    //         //     $request['sambandhit_javak_kramank'] = $request->sambandhit_javak_kramank->store('trade/noc-for-mandap');
    //         // }if ($request->hasFile('stanikpolice_javak_kramank')) {
    //         //     if ($tradeNocForMandap && Storage::exists($tradeNocForMandap->stanikpolice_javak_kramank)) {
    //         //         Storage::delete($tradeNocForMandap->stanikpolice_javak_kramank);
    //         //     }
    //         //     $request['stanikpolice_javak_kramank'] = $request->stanikpolice_javak_kramank->store('trade/noc-for-mandap');
    //         // }

    //         $tradeNocForMandap->agnishamak_javak_kramank = $request->input('agnishamak_javak_kramank');
    //         $tradeNocForMandap->stanikpolice_javak_kramank = $request->input('stanikpolice_javak_kramank');
    //         $tradeNocForMandap->sambandhit_javak_kramank = $request->input('sambandhit_javak_kramank');



    //         $tradeNocForMandap->agnishamak_police_date = $request->input('agnishamak_police_date');
    //         $tradeNocForMandap->stanikpolice_date = $request->input('stanikpolice_date');
    //         $tradeNocForMandap->sambandhit_date = $request->input('sambandhit_date');
    //         //ksihroi end code //

    //         $tradeNocForMandap->fill($request->except([
    //         'agnishamak_javak_kramank',
    //         'sambandhit_javak_kramank',
    //         'stanikpolice_javak_kramank',
    //     ]));

       
    //         DB::commit();
    //         return [true];
    //     } catch (\Exception $e) {
    //         DB::rollback();
    //         Log::info($e);
    //         return [false, $e->getMessage()];
    //     }
    // }
    //kishori end the code//


    public function update($request, $id)
{
    DB::beginTransaction();
    try {
        $tradeNocForMandap = TradeNocForMandap::findOrFail($id);

        // Set simple text values directly
        $tradeNocForMandap->agnishamak_javak_kramank = $request->input('agnishamak_javak_kramank');
        $tradeNocForMandap->sambandhit_javak_kramank = $request->input('sambandhit_javak_kramank');
        $tradeNocForMandap->stanikpolice_javak_kramank = $request->input('stanikpolice_javak_kramank');

        $tradeNocForMandap->agnishamak_police_date = $request->input('agnishamak_police_date');
        $tradeNocForMandap->stanikpolice_date = $request->input('stanikpolice_date');
        $tradeNocForMandap->sambandhit_date = $request->input('sambandhit_date');

        // Fill remaining fields
        $tradeNocForMandap->fill($request->except([
            'agnishamak_javak_kramank',
            'sambandhit_javak_kramank',
            'stanikpolice_javak_kramank',
            'agnishamak_police_date',
            'stanikpolice_date',
            'sambandhit_date',
        ]));

        $tradeNocForMandap->save();

        DB::commit();
        return [true];
    } catch (\Exception $e) {
        DB::rollback();
        Log::info($e);
        return [false, $e->getMessage()];
    }
}

}
