<?php

namespace App\Services\Trade;

use App\Models\Status;
use App\Services\CommonService;
use App\Models\ServiceCredential;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Trade\RenewMarriageLicense;
use App\Services\AapaleSarkarLoginCheckService;

class RenewLicenseMarriageService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {

        $request['user_id'] = Auth::user()->id;
        $request['service_id'] = "2030";


        if ($request->hasFile('director_photos')) {
            $request['director_image'] = $request->director_photos->store('mobile-tower');
        }

        if ($request->hasFile('upload_prescribed_formats')) {
            $request['other_documents'] = $request->upload_prescribed_formats->store('mobile-tower');
        }

        if ($request->hasFile('ownership')) {
            $request['market_license'] = $request->ownership->store('mobile-tower');
        }

        if ($request->hasFile('water_bills')) {
            $request['food_drug_img'] = $request->water_bills->store('mobile-tower');
        }

        if ($request->hasFile('society')) {
            $request['shop_act'] = $request->society->store('mobile-tower');
        }

        if ($request->hasFile('place')) {
            $request['fire_certificate'] = $request->place->store('mobile-tower');
        }

        if ($request->hasFile('aadhar_pans')) {
            $request['pancard_image'] = $request->aadhar_pans->store('mobile-tower');
        }
        if ($request->hasFile('property')) {
            $request['aadharcard_image'] = $request->property->store('mobile-tower');
        }

        if ($request->hasFile('tenancy')) {
            $request['tax_receipt_img'] = $request->tenancy->store('mobile-tower');
        }

        if ($request->hasFile('occupancy')) {
            $request['interior_photo'] = $request->occupancy->store('mobile-tower');
        }

        if ($request->hasFile('medical')) {
            $request['exterior_photo'] = $request->medical->store('mobile-tower');
        }

        if ($request->hasFile('prescribed_docs')) {
            $request['prescribed_doc'] = $request->prescribed_docs->store('mobile-tower');
        }
        $renewLicenseMarriage = RenewMarriageLicense::create($request->except('application_no'));
        if ($renewLicenseMarriage) {

            $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $renewLicenseMarriage->id . '/' . date('dmY');
            $renewLicenseMarriage->application_no = $applicationNo;
            $renewLicenseMarriage->save();

            $status = Status::create([
                'service_id' => 2030,
                'department_id' => 6,
                'table_id' => $renewLicenseMarriage->id,
                'user_id' => Auth::user()->id
            ]);

            $this->commonservice->store_approval_hierarchies($renewLicenseMarriage, Auth::user(), $status);
        }


        DB::commit();
        return [true];
    }

    public function edit($id)
    {
        return RenewMarriageLicense::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $renewLicenseMarriage = RenewMarriageLicense::find($id);

            // Handle file uploads and update original file names
            if ($request->hasFile('director_photos')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->director_image &&  $renewLicenseMarriage->director_image && Storage::exists($renewLicenseMarriage->director_image)) {
                    Storage::delete($renewLicenseMarriage->director_image);
                }
                $request['director_image'] = $request->director_photos->store('mobile-tower');
            }


            if ($request->hasFile('upload_prescribed_formats')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->other_documents &&  $renewLicenseMarriage->other_documents && Storage::exists($renewLicenseMarriage->other_documents)) {
                    Storage::delete($renewLicenseMarriage->other_documents);
                }
                $request['other_documents'] = $request->upload_prescribed_formats->store('mobile-tower');
            }

            if ($request->hasFile('aadhar_pans')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->pancard_image && Storage::exists($renewLicenseMarriage->pancard_image)) {
                    Storage::delete($renewLicenseMarriage->pancard_image);
                }
                $request['pancard_image'] = $request->aadhar_pans->store('mobile-tower');
            }

            if ($request->hasFile('ownership')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->market_license && Storage::exists($renewLicenseMarriage->market_license)) {
                    Storage::delete($renewLicenseMarriage->market_license);
                }
                $request['market_license'] = $request->ownership->store('mobile-tower');
            }


            if ($request->hasFile('water_bills')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->food_drug_img && Storage::exists($renewLicenseMarriage->food_drug_img)) {
                    Storage::delete($renewLicenseMarriage->food_drug_img);
                }
                $request['food_drug_img'] = $request->water_bills->store('mobile-tower');
            }


            if ($request->hasFile('society')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->shop_act && Storage::exists($renewLicenseMarriage->shop_act)) {
                    Storage::delete($renewLicenseMarriage->shop_act);
                }
                $request['shop_act'] = $request->society->store('mobile-tower');
            }


            if ($request->hasFile('place')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->fire_certificate && Storage::exists($renewLicenseMarriage->fire_certificate)) {
                    Storage::delete($renewLicenseMarriage->fire_certificate);
                }
                $request['fire_certificate'] = $request->place->store('mobile-tower');
            }

            if ($request->hasFile('property')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->aadharcard_image && Storage::exists($renewLicenseMarriage->aadharcard_image)) {
                    Storage::delete($renewLicenseMarriage->aadharcard_image);
                }
                $request['aadharcard_image'] = $request->property->store('mobile-tower');
            }

            if ($request->hasFile('tenancy')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->tax_receipt_img && Storage::exists($renewLicenseMarriage->tax_receipt_img)) {
                    Storage::delete($renewLicenseMarriage->tax_receipt_img);
                }
                $request['tax_receipt_img'] = $request->tenancy->store('mobile-tower');
            }




            if ($request->hasFile('occupancy')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->interior_photo && Storage::exists($renewLicenseMarriage->interior_photo)) {
                    Storage::delete($renewLicenseMarriage->interior_photo);
                }
                $request['interior_photo'] = $request->occupancy->store('mobile-tower');
            }

            if ($request->hasFile('medical')) {
                if ($renewLicenseMarriage &&  $renewLicenseMarriage->exterior_photo && Storage::exists($renewLicenseMarriage->exterior_photo)) {
                    Storage::delete($renewLicenseMarriage->exterior_photo);
                }
                $request['exterior_photo'] = $request->medical->store('mobile-tower');
            }

            $renewLicenseMarriage->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
