<?php

namespace App\Services\TreeAuth;

use App\Services\AapaleSarkarLoginCheckService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use App\Models\ServiceCredential;
use App\Models\TreeAuth\TreeProtection;
use App\Models\Status;
use App\Services\CommonService;
use Exception;

class TreeProtectionService
{
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonservice)
    {
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonservice = $commonservice;
    }


    public function store($request)
    {
        DB::beginTransaction();
        try {
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "2033";


            if ($request->hasFile('paid_receipts')) {
                $request['paid_receipt'] = $request->paid_receipts->store('tree-protection');
            }

            if ($request->hasFile('photo_trees')) {
                $request['photo_tree'] = $request->photo_trees->store('tree-protection');
            }
            if ($request->hasFile('aadhars')) {
                $request['aadhar'] = $request->aadhars->store('tree-protection');
            }
            if ($request->has('mobile_no')) {
                $request->merge(['mobile_num' => $request->mobile_no]);
            }

            if ($request->hasFile('building_permissions')) {
                $request['building_permission'] = $request->building_permissions->store('tree-protection');
            }
            if ($request->hasFile('plan_constructions')) {
                $request['plan_construction'] = $request->plan_constructions->store('tree-protection');
            }
            if ($request->hasFile('noc_letters')) {
                $request['noc_letter'] = $request->noc_letters->store('tree-protection');
            }

            if ($request->hasFile('prescribed_docs')) {
                $request['prescribed_doc'] = $request->prescribed_docs->store('tree-protection');
            }

            $treeProtection = TreeProtection::create($request->except([
                'application_no',
                'mobile_no',
                'item1',
                'item2',
                'item3',
                'item4',
                'item5',
                'item6',
                'item7',
                'item8',
                'item9',
                'paid_receipts',
                'photo_trees',
                'prescribed_docs',
                'noc_letters',
                'plan_constructions',
                'building_permissions',
                'aadhars',
                'is_correct_info',
            ]));

            if ($treeProtection) {
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $treeProtection->id . '/' . date('dmY');
                $treeProtection->application_no = $applicationNo;
                $treeProtection->save();

                $status  =  Status::create([
                    'service_id' => 2033,
                    'department_id' => 9,
                    'table_id' => $treeProtection->id,
                    'user_id' => Auth::user()->id
                ]);

                $this->commonservice->store_approval_hierarchies($treeProtection, Auth::user(), $status);
            }
            DB::commit();
            return [true];
        } catch (Exception $e) {
            Log::info('exception in create tree protection service', [$e->getMessage()]);
            DB::rollback();
            return [false];
        }
    }

    public function edit($id)
    {
        return TreeProtection::find($id);
    }

    public function update($request, $id)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            // Find the existing record
            $treeProtection = TreeProtection::find($id);

            // Handle file uploads and update original file names

            $treeProtection->update($request->all());

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
